/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.info.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.info.dao.NewsTypeMapper;
import com.jtech.toa.info.domain.NewsType;
import com.jtech.toa.info.model.query.NewsTypeQuery;
import com.jtech.toa.info.service.INewsTypeService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsTypeServiceImpl
extends ServiceImpl<NewsTypeMapper, NewsType>
implements INewsTypeService {
    @Override
    public boolean getNewsByType(long id) {
        int res = ((NewsTypeMapper)this.baseMapper).getNewsByType(id);
        return res == 0;
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<NewsType> findByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.absent();
        }
        NewsType newsType = ((NewsTypeMapper)this.baseMapper).selectByName(name);
        if (newsType == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)newsType));
    }

    @Override
    public boolean addNewsType(NewsType newsType) {
        newsType.setCreateTime(DateUtil.unixTime());
        newsType.setDeleteFlag(0);
        return ((NewsTypeMapper)this.baseMapper).insert((Object)newsType) == 1;
    }

    @Override
    public boolean updateNewsType(NewsType newsType) {
        newsType.setUpdateTime(DateUtil.unixTime());
        return ((NewsTypeMapper)this.baseMapper).updateById((Object)newsType) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<NewsType> requestPage, NewsTypeQuery query) {
        List<NewsType> newsType = ((NewsTypeMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(newsType);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<NewsType> findByPagination(Page<NewsType> pageResult, List<Sort.Order> orders) {
        List<NewsType> newsTypes = ((NewsTypeMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(newsTypes);
        return pageResult;
    }

    @Override
    @Transactional(readOnly=true)
    public List<NewsType> selectStartType() {
        return ((NewsTypeMapper)this.baseMapper).selectStartType();
    }

    @Override
    public List<NewsType> selectByHomeflag(boolean homeFlag) {
        List<NewsType> typeList = ((NewsTypeMapper)this.baseMapper).selectByHomeflag(homeFlag);
        return typeList;
    }
}

