/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.controller.api;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableBiMap;
import com.jtech.marble.error.ErrorCode;
import com.jtech.marble.exception.ParamCheckException;
import com.jtech.toa.process.constants.DataSourceCode;
import com.jtech.toa.process.manager.IDatasourceManager;
import com.jtech.toa.process.model.vo.DatasourceComboVO;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/datasource"})
public class DatasourceRestController {
    private final IDatasourceManager datasourceManager;

    @Autowired
    public DatasourceRestController(IDatasourceManager datasourceManager) {
        this.datasourceManager = datasourceManager;
    }

    @GetMapping(value={"combo"})
    public ResponseEntity combo(@RequestParam(value="table") String table, @RequestParam(value="field", required=false) String field, @RequestParam(value="keyword", required=false) String keyword) {
        if (Strings.isNullOrEmpty((String)table)) {
            throw new ParamCheckException((ErrorCode)DataSourceCode.CODE_EMPTY);
        }
        DatasourceComboVO comboVO = this.datasourceManager.execWithCombo(table, field, keyword);
        return ResponseEntity.ok((Object)comboVO);
    }

    @GetMapping(value={"triggerselect"})
    public ResponseEntity triggerselect(@RequestParam(value="table") String table, @RequestParam(value="query", required=false) String query) {
        if (Strings.isNullOrEmpty((String)table)) {
            throw new ParamCheckException((ErrorCode)DataSourceCode.CODE_EMPTY);
        }
        List<Map<String, Object>> data = this.datasourceManager.execWithSelect(table, query);
        ImmutableBiMap result = ImmutableBiMap.of((Object)"data", data);
        return ResponseEntity.ok((Object)result);
    }
}

