/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.text.StrUtil;
import com.jtech.toa.process.dao.DatasourceMapper;
import com.jtech.toa.process.domain.Datasource;
import com.jtech.toa.process.domain.DatasourceCombo;
import com.jtech.toa.process.domain.DatasourceConditions;
import com.jtech.toa.process.domain.DatasourceFiled;
import com.jtech.toa.process.domain.DatasourcePopover;
import com.jtech.toa.process.domain.ZZTableField;
import com.jtech.toa.process.model.dto.DataSourceFromDTO;
import com.jtech.toa.process.model.vo.SourceFieldVO;
import com.jtech.toa.process.model.vo.SourceVO;
import com.jtech.toa.process.service.IDatasourceComboService;
import com.jtech.toa.process.service.IDatasourceConditionsService;
import com.jtech.toa.process.service.IDatasourceFiledService;
import com.jtech.toa.process.service.IDatasourcePopoverService;
import com.jtech.toa.process.service.IDatasourceService;
import com.xiaoleilu.hutool.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatasourceServiceImpl
extends ServiceImpl<DatasourceMapper, Datasource>
implements IDatasourceService {
    private final IDatasourceFiledService dataSourceFiledService;
    private final IDatasourceConditionsService dataSourceConditionsService;
    private final IDatasourceComboService datasourceComboService;
    private final IDatasourcePopoverService datasourcePopoverService;

    @Autowired
    public DatasourceServiceImpl(IDatasourceFiledService dataSourceFiledService, IDatasourceConditionsService dataSourceConditionsService, IDatasourceComboService datasourceComboService, IDatasourcePopoverService datasourcePopoverService) {
        this.dataSourceFiledService = dataSourceFiledService;
        this.dataSourceConditionsService = dataSourceConditionsService;
        this.datasourceComboService = datasourceComboService;
        this.datasourcePopoverService = datasourcePopoverService;
    }

    @Override
    public Datasource selectByCode(String tableCode) {
        if (Strings.isNullOrEmpty((String)tableCode)) {
            return null;
        }
        return ((DatasourceMapper)this.baseMapper).selectByCode(tableCode);
    }

    @Override
    @Transactional(readOnly=true)
    @Cacheable(value={"form-ds-cache"})
    public List<SourceVO> selectAllWithForm() {
        List<Datasource> dataSources = ((DatasourceMapper)this.baseMapper).selectAllWithForm();
        if (CollectionUtil.isEmpty(dataSources)) {
            return Collections.emptyList();
        }
        List<DatasourceFiled> dataSourceFileds = this.dataSourceFiledService.selectAllWithForm();
        Function<DatasourceFiled, Long> groupFunc = new Function<DatasourceFiled, Long>(){

            public Long apply(DatasourceFiled input) {
                Long dataSourceId = input.getDatasourceId();
                if (dataSourceId == null) {
                    return 0L;
                }
                return dataSourceId;
            }
        };
        ImmutableListMultimap dsIndex = Multimaps.index(dataSourceFileds, (Function)groupFunc);
        Map groupResultMap = dsIndex.asMap();
        ArrayList sourceVOList = Lists.newArrayListWithCapacity((int)dataSources.size());
        for (Datasource dataSource : dataSources) {
            SourceVO sourceVO = new SourceVO();
            sourceVO.setTable(dataSource.getCode());
            sourceVO.setName(dataSource.getName());
            Collection fileds = (Collection)groupResultMap.get(dataSource.getId());
            ArrayList fieldVOS = Lists.newArrayList();
            for (DatasourceFiled filed : fileds) {
                SourceFieldVO sourceFieldVO = new SourceFieldVO();
                sourceFieldVO.setField(filed.getFiledCode());
                sourceFieldVO.setName(filed.getFiledName());
                sourceFieldVO.setVtype(filed.getFiledType());
                fieldVOS.add(sourceFieldVO);
            }
            sourceVO.setFields(fieldVOS);
            sourceVOList.add(sourceVO);
        }
        return sourceVOList;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Datasource> gridByPagination(Page<Datasource> requestPage, List<Sort.Order> orders) {
        List<Datasource> dataSources = ((DatasourceMapper)this.baseMapper).selectByPagination(requestPage, orders);
        requestPage.setRecords(dataSources);
        return requestPage;
    }

    @Override
    @Transactional
    @CachePut(value={"form-ds-cache"})
    public Datasource saveDataSource(DataSourceFromDTO dataSourceFromDTO, long loginUserId) throws DaoException {
        Datasource dataSource = dataSourceFromDTO.getDataSource();
        List<DatasourceFiled> fileds = dataSourceFromDTO.getFileds();
        List<DatasourceConditions> conditions = dataSourceFromDTO.getConditions();
        DatasourceCombo combo = dataSourceFromDTO.getCombo();
        DatasourcePopover popover = dataSourceFromDTO.getPopover();
        int unixTime = DateUtil.unixTime();
        Integer dsType = dataSource.getDsType();
        if (ObjectUtil.isNotNull((Object)dsType)) {
            if (dsType == 1 && CollectionUtil.isNotEmpty(fileds)) {
                String sqlScript = "";
                StringBuilder sqlBuild = new StringBuilder("SELECT ");
                ArrayList cloumns = Lists.newArrayList();
                for (DatasourceFiled filed : fileds) {
                    cloumns.add(filed.getFiledCode());
                }
                sqlBuild.append(StrUtil.join((String)",", (List)cloumns)).append(" ").append("FROM").append(" ").append(dataSource.getTableName());
                sqlScript = this.sqlAddConditions(sqlBuild, conditions);
                dataSource.setSqlScript(sqlScript);
            }
            if (dsType == 2) {
                StringBuilder sqlBuild = new StringBuilder(dataSource.getSqlScript());
                String sqlScript = this.sqlAddConditions(sqlBuild, conditions);
                dataSource.setSqlScript(sqlScript);
            }
        }
        boolean state = false;
        long dsId = (Long)MoreObjects.firstNonNull((Object)dataSource.getId(), (Object)0L);
        if (dsId > 0L) {
            boolean removeState;
            boolean removeState2;
            boolean removeState3;
            boolean removeState4;
            dataSource.setUpdater(loginUserId);
            dataSource.setUpdateTime(unixTime);
            List<DatasourceFiled> datasourceFileds = this.dataSourceFiledService.selectByDataSourceId(dsId);
            if (CollectionUtil.isNotEmpty(datasourceFileds) && !(removeState4 = this.dataSourceFiledService.deleteByDatasourceId(dsId))) {
                throw new DaoException("\u5220\u9664\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25");
            }
            List<DatasourceConditions> datasourceConditionss = this.dataSourceConditionsService.selectByDataSourceId(dsId);
            if (CollectionUtil.isNotEmpty(datasourceConditionss) && !(removeState3 = this.dataSourceConditionsService.deleteByDatasourceId(dsId))) {
                throw new DaoException("\u5220\u9664\u6761\u4ef6\u4fe1\u606f\u5931\u8d25");
            }
            Object datasourceCombo = this.datasourceComboService.selectByDatasourceId(dsId);
            if (datasourceCombo != null && !(removeState2 = this.datasourceComboService.deleteByDatasourceId(dsId))) {
                throw new DaoException("\u5220\u9664\u4e0b\u62c9\u6846\u4fe1\u606f\u5931\u8d25");
            }
            DatasourcePopover datasourcePopover = this.datasourcePopoverService.selectByDataSourceId(dsId);
            if (datasourcePopover != null && !(removeState = this.datasourcePopoverService.deleteByDatasourceId(dsId))) {
                throw new DaoException("\u5220\u9664\u5f39\u51fa\u6846\u5931\u8d25");
            }
            int updateState = ((DatasourceMapper)this.baseMapper).updateById((Object)dataSource);
            boolean bl = state = updateState > 0;
            if (updateState <= 0) {
                throw new DaoException("\u66f4\u65b0\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            dataSource.setCreater(loginUserId);
            dataSource.setCreateTime(unixTime);
            Integer insertRows = ((DatasourceMapper)this.baseMapper).insert((Object)dataSource);
            state = insertRows > 0;
        }
        long dataSourceId = dataSource.getId();
        if (CollectionUtil.isNotEmpty(fileds) && state) {
            for (DatasourceFiled filed : fileds) {
                filed.setDatasourceId(dataSourceId);
                filed.setCreater(loginUserId);
                filed.setCreateTime(unixTime);
            }
            boolean b = this.dataSourceFiledService.insertBatch(fileds);
            if (!b) {
                throw new DaoException("\u5199\u5165\u5b57\u6bb5\u53d1\u751f\u9519\u8bef");
            }
        }
        if (CollectionUtil.isNotEmpty(conditions) && state) {
            for (DatasourceConditions condition : conditions) {
                condition.setId(null);
                condition.setDatasourceId(dataSourceId);
                condition.setCreater(loginUserId);
                condition.setCreateTime(unixTime);
            }
            boolean res = this.dataSourceConditionsService.insertBatch(conditions);
            if (!res) {
                throw new DaoException("\u5199\u5165\u6570\u636e\u6e90\u6761\u4ef6\u53d1\u751f\u9519\u8bef");
            }
        }
        if (combo != null) {
            combo.setDatasourceId(dataSourceId);
            combo.setCreater(loginUserId);
            combo.setCreateTime(unixTime);
            boolean res = this.datasourceComboService.insert((Object)combo);
            if (!res) {
                throw new DaoException("\u5199\u5165\u6570\u636e\u6e90\u4e0b\u62c9\u6846\u8868\u53d1\u751f\u9519\u8bef");
            }
        }
        if (popover != null) {
            String tableHeadFields = popover.getTableHeadFields();
            String tableHeadFieldsParseRes = this.parseField(tableHeadFields, fileds);
            popover.setTableHeadFields(tableHeadFieldsParseRes);
            String searchFields = popover.getSearchFields();
            String searchFieldsParseRes = this.parseField(searchFields, fileds);
            popover.setSearchFields(searchFieldsParseRes);
            popover.setDatasourceId(dataSourceId);
            popover.setCreater(loginUserId);
            popover.setCreateTime(unixTime);
            boolean res = this.datasourcePopoverService.insert((Object)popover);
            if (!res) {
                throw new DaoException("\u5199\u5165\u6570\u636e\u6e90\u5f39\u51fa\u6846\u8868\u53d1\u751f\u9519\u8bef");
            }
        }
        return dataSource;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ZZTableField> mysqlQueryFieldByTable(String tableName) {
        Preconditions.checkNotNull((Object)tableName);
        return ((DatasourceMapper)this.baseMapper).mysqlQueryFieldByTable(tableName);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> mysqlQueryTables() {
        return ((DatasourceMapper)this.baseMapper).mysqlQueryTables();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Map<String, Object>> executeSql(String sql, String field, String keyword) {
        String sql_script;
        HashMap param = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)field)) {
            HashMap tplParam = Maps.newHashMap();
            tplParam.put("sql", sql);
            tplParam.put("field", field);
            sql_script = StrUtil.format((String)"{sql} AND {field} LIKE #{{field}}", (Map)tplParam);
            param.put(field, SqlUtils.concatLike((String)keyword, (SqlLike)SqlLike.DEFAULT));
        } else {
            sql_script = sql;
        }
        param.put("_sql", sql_script);
        return ((DatasourceMapper)this.baseMapper).executeSql(param);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Map<String, Object>> executeSql(String sql, Map<String, String> sqlParams) {
        String sql_script;
        HashMap param = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(sqlParams)) {
            StringBuilder sqlBuild = new StringBuilder(sql);
            for (String queryField : sqlParams.keySet()) {
                String queryValue = sqlParams.get(queryField);
                if (queryValue == null) continue;
                HashMap tplParam = Maps.newHashMap();
                tplParam.put("field", queryField);
                String conditionSql = StrUtil.format((String)" AND {field} LIKE #{{field}}", (Map)tplParam);
                sqlBuild.append(conditionSql);
                param.put(queryField, SqlUtils.concatLike((String)queryValue, (SqlLike)SqlLike.DEFAULT));
            }
            sql_script = sqlBuild.toString();
        } else {
            sql_script = sql;
        }
        param.put("_sql", sql_script);
        return ((DatasourceMapper)this.baseMapper).executeSql(param);
    }

    private String parseField(String fields, List<DatasourceFiled> datasourceFileds) {
        ArrayList fieldList = Lists.newArrayList();
        List fieldStrs = JSON.parseArray((String)fields, String.class);
        for (String fieldStr : fieldStrs) {
            for (DatasourceFiled datasourceFiled : datasourceFileds) {
                if (!StringUtils.equals((CharSequence)fieldStr, (CharSequence)datasourceFiled.getFiledCode())) continue;
                HashMap fieldTemp = Maps.newHashMap();
                fieldTemp.put("label", datasourceFiled.getFiledName());
                fieldTemp.put("field", fieldStr);
                fieldList.add(fieldTemp);
            }
        }
        return JSON.toJSONString((Object)fieldList);
    }

    private String sqlAddConditions(StringBuilder sqlBuild, List<DatasourceConditions> conditions) {
        sqlBuild.append(" ").append("WHERE").append(" ");
        if (CollectionUtil.isNotEmpty(conditions)) {
            for (DatasourceConditions condition : conditions) {
                if (!condition.getInputFlag()) {
                    sqlBuild.append(condition.getConditionCode()).append("=").append(condition.getInputValue()).append(" ").append("AND").append(" ");
                    continue;
                }
                sqlBuild.append(condition.getConditionCode()).append("=").append("?").append(" ").append("AND").append(" ");
            }
        }
        return sqlBuild.append(1).append("=").append(1).append(" ").toString();
    }
}

