/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.toa.process.dao.NodeFormConditionMapper;
import com.jtech.toa.process.domain.NodeFormApprover;
import com.jtech.toa.process.domain.NodeFormCondition;
import com.jtech.toa.process.service.INodeFormApproverService;
import com.jtech.toa.process.service.INodeFormConditionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NodeFormConditionServiceImpl
extends ServiceImpl<NodeFormConditionMapper, NodeFormCondition>
implements INodeFormConditionService {
    private final INodeFormApproverService processNodeFormApproverService;

    @Autowired
    public NodeFormConditionServiceImpl(INodeFormApproverService processNodeFormApproverService) {
        this.processNodeFormApproverService = processNodeFormApproverService;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(List<NodeFormCondition> formConditions, long processId) {
        ArrayList allApprovers = Lists.newArrayList();
        for (NodeFormCondition formCondition : formConditions) {
            List<NodeFormApprover> approvers = formCondition.getApprovers();
            if (!CollectionUtil.isNotEmpty(approvers)) continue;
            allApprovers.addAll(approvers);
        }
        ((NodeFormConditionMapper)this.baseMapper).deleteByProcessId(processId);
        boolean formConditionState = this.insertBatch(formConditions);
        if (!formConditionState) {
            throw new DaoException("save process form condtition has error!");
        }
        if (CollectionUtil.isNotEmpty((Collection)allApprovers)) {
            this.processNodeFormApproverService.saveOrUpdate(allApprovers, processId);
        }
        return true;
    }
}

