/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jtech.marble.error.BaseErrorCode;
import com.jtech.marble.error.ErrorCode;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.exception.ParamCheckException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.process.constants.ProcessCode;
import com.jtech.toa.process.dao.ProcessDesingerMapper;
import com.jtech.toa.process.domain.NodeFormCondition;
import com.jtech.toa.process.domain.NodeFormField;
import com.jtech.toa.process.domain.NodeOper;
import com.jtech.toa.process.domain.NodeSpecuser;
import com.jtech.toa.process.domain.Process;
import com.jtech.toa.process.domain.ProcessDesinger;
import com.jtech.toa.process.model.vo.ProcessDesingerVO;
import com.jtech.toa.process.model.vo.ProcessNodeVO;
import com.jtech.toa.process.model.vo.ProcessUserVO;
import com.jtech.toa.process.service.INodeFormConditionService;
import com.jtech.toa.process.service.INodeFormFieldService;
import com.jtech.toa.process.service.INodeOperService;
import com.jtech.toa.process.service.INodeSpecuserService;
import com.jtech.toa.process.service.IProcessDesingerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessDesingerServiceImpl
extends ServiceImpl<ProcessDesingerMapper, ProcessDesinger>
implements IProcessDesingerService {
    private final INodeFormConditionService nodeFormConditionService;
    private final INodeSpecuserService nodeSpecuserService;
    private final INodeOperService nodeOperService;
    private final INodeFormFieldService nodeFormFieldService;

    public ProcessDesingerServiceImpl(INodeFormConditionService nodeFormConditionService, INodeSpecuserService nodeSpecuserService, INodeOperService nodeOperService, INodeFormFieldService nodeFormFieldService) {
        this.nodeFormConditionService = nodeFormConditionService;
        this.nodeSpecuserService = nodeSpecuserService;
        this.nodeOperService = nodeOperService;
        this.nodeFormFieldService = nodeFormFieldService;
    }

    @Override
    @Transactional
    public void saveOrUpdateByProcess(Long processId, String processDesingerJSON, ProcessDesingerVO processDesingerVO) {
        ProcessDesinger desinger = (ProcessDesinger)((Object)this.selectById(processId));
        if (desinger == null) {
            desinger = new ProcessDesinger();
            desinger.setProcessId(processId);
            desinger.setProcessXml(processDesingerVO.getXml());
            desinger.setDesingerJson(processDesingerJSON);
            boolean desingerSaveState = this.insert((Object)desinger);
            if (!desingerSaveState) {
                throw new DaoException("\u6d41\u7a0b\u8bbe\u8ba1\u4fe1\u606f\u4fdd\u5b58\u9519\u8bef");
            }
        } else {
            desinger.setProcessXml(processDesingerVO.getXml());
            desinger.setDesingerJson(processDesingerJSON);
            boolean desingerUpdateState = this.updateById((Object)desinger);
            if (!desingerUpdateState) {
                throw new DaoException("\u6d41\u7a0b\u8bbe\u8ba1\u4fe1\u606f\u4fdd\u5b58\u9519\u8bef");
            }
        }
    }

    @Override
    @Transactional
    public void saveProcessAndSetting(String processDesingerJSON, Process process, ShiroUser loginUser) {
        ProcessDesingerVO processDesingerVO;
        Preconditions.checkNotNull((Object)processDesingerJSON, (Object)"\u6d41\u7a0b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        long processId = (Long)MoreObjects.firstNonNull((Object)process.getId(), (Object)0L);
        if (processId <= 0L) {
            throw new ParamCheckException((ErrorCode)BaseErrorCode.ERRROR, "\u6d41\u7a0bID\u4e0d\u80fd\u4e3a0");
        }
        try {
            processDesingerVO = (ProcessDesingerVO)JSON.parseObject((String)processDesingerJSON, ProcessDesingerVO.class);
        }
        catch (Exception e) {
            throw new ParamCheckException((ErrorCode)BaseErrorCode.ERRROR, "JSON\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String processXML = processDesingerVO.getXml();
        if (Strings.isNullOrEmpty((String)processXML)) {
            throw new ParamCheckException((ErrorCode)ProcessCode.PROCESS_DESINGER_XML);
        }
        this.parseAndSave(processDesingerJSON, loginUser, processId, processDesingerVO);
    }

    private void parseAndSave(String processDesingerJSON, ShiroUser loginUser, long processId, ProcessDesingerVO processDesingerVO) {
        List<ProcessNodeVO> nodeSettings = processDesingerVO.getNodeSettings();
        long loginUserId = loginUser.getId();
        int unixTime = DateUtil.unixTime();
        ArrayList nodeOpers = Lists.newArrayList();
        ArrayList nodeFormFields = Lists.newArrayList();
        List<NodeSpecuser> specusers = null;
        List<NodeFormCondition> formConditions = null;
        for (ProcessNodeVO nodeSetting : nodeSettings) {
            String ntype = nodeSetting.getNtype();
            if (!StringUtils.equals((CharSequence)ntype, (CharSequence)"line") && !StringUtils.equals((CharSequence)ntype, (CharSequence)"task")) continue;
            long nodeOperId = IdWorker.getId();
            NodeOper nodeOper = new NodeOper();
            nodeOper.setId(nodeOperId);
            nodeOper.setTaskNodeId(nodeSetting.getNodeId());
            nodeOper.setProcessId(processId);
            nodeOper.setCreater(loginUserId);
            nodeOper.setCreateTime(unixTime);
            int approverType = nodeSetting.getApproverType();
            switch (approverType) {
                case 1: {
                    nodeOper.setAssignerType(2);
                    List<ProcessUserVO> assignUsers = nodeSetting.getAssignUsers();
                    nodeOper.setSpecUser(JSON.toJSONString(assignUsers));
                    nodeSetting.toSpecUsers(nodeOperId);
                    specusers = nodeSetting.toSpecUsers(nodeOperId);
                    nodeOper.setFormExp("jtoa:user:" + nodeOperId);
                    break;
                }
                case 2: {
                    nodeOper.setAssignerType(3);
                    nodeOper.setSpecPosition(nodeSetting.getAssignPosition());
                    nodeOper.setFormExp("jtoa:position:" + nodeOperId);
                    break;
                }
                case 3: {
                    nodeOper.setAssignerType(9);
                    nodeOper.setFormWidgetName(nodeSetting.getAssignFormItemWidget());
                    nodeOper.setFormExp("jtoa:formfield:" + nodeOperId);
                    break;
                }
                case 4: {
                    nodeOper.setAssignerType(10);
                    formConditions = nodeSetting.toFormCondition(nodeOperId, processId);
                    nodeOper.setFormExp("jtoa:formcondition:" + nodeOperId);
                    break;
                }
                case 7: {
                    nodeOper.setAssignerType(7);
                    nodeOper.setFormExp("jtoa:directsupervisor:" + nodeOperId);
                    break;
                }
                case 8: {
                    nodeOper.setAssignerType(1);
                    nodeOper.setFormExp("jtoa:noset:" + nodeOperId);
                    break;
                }
            }
            nodeOpers.add(nodeOper);
            List<NodeFormField> formFields = nodeSetting.toFormField(processId);
            if (!CollectionUtil.isNotEmpty(formFields)) continue;
            nodeFormFields.addAll(formFields);
        }
        if (CollectionUtil.isNotEmpty((Collection)nodeOpers)) {
            this.nodeOperService.saveOrUpdateNodeOpers(nodeOpers, processId);
        }
        if (CollectionUtil.isNotEmpty(specusers)) {
            this.nodeSpecuserService.saveOrUpdate(specusers, processId);
        }
        if (CollectionUtil.isNotEmpty(formConditions)) {
            this.nodeFormConditionService.saveOrUpdate(formConditions, processId);
        }
        if (CollectionUtil.isNotEmpty((Collection)nodeFormFields)) {
            this.nodeFormFieldService.saveOrUpdate(nodeFormFields, processId);
        }
        this.saveOrUpdateByProcess(processId, processDesingerJSON, processDesingerVO);
    }
}

