/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.jtech.marble.error.ErrorCode;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.io.FilePathUtil;
import com.jtech.marble.util.text.StrUtil;
import com.jtech.toa.form.domain.Form;
import com.jtech.toa.form.domain.FormDesinger;
import com.jtech.toa.form.model.dto.FormAttrDto;
import com.jtech.toa.form.model.dto.FormDesignerDto;
import com.jtech.toa.form.service.IFormDesingerService;
import com.jtech.toa.form.service.IFormService;
import com.jtech.toa.process.constants.ProcessCode;
import com.jtech.toa.process.constants.ProcessConst;
import com.jtech.toa.process.dao.ProcessMapper;
import com.jtech.toa.process.domain.Process;
import com.jtech.toa.process.domain.ProcessDesinger;
import com.jtech.toa.process.exception.ProcessBizException;
import com.jtech.toa.process.model.dto.ProcessDetailDTO;
import com.jtech.toa.process.model.dto.ProcessGridDTO;
import com.jtech.toa.process.model.vo.ProcessDesingerVO;
import com.jtech.toa.process.model.vo.ProcessListVO;
import com.jtech.toa.process.model.vo.ProcessNodeVO;
import com.jtech.toa.process.service.IProcessDesingerService;
import com.jtech.toa.process.service.IProcessService;
import com.jtech.toa.process.util.BpmnXmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;

@Service
public class ProcessServiceImpl
extends ServiceImpl<ProcessMapper, Process>
implements IProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessServiceImpl.class);
    private final IFormService formService;
    private final IFormDesingerService formDesingerService;
    private final IProcessDesingerService processDesingerService;
    private final RepositoryService repositoryService;

    @Autowired
    public ProcessServiceImpl(IFormService formService, IFormDesingerService formDesingerService, IProcessDesingerService processDesingerService, RepositoryService repositoryService) {
        this.formService = formService;
        this.formDesingerService = formDesingerService;
        this.processDesingerService = processDesingerService;
        this.repositoryService = repositoryService;
    }

    @Override
    @Transactional
    public void saveProcess(Process process, ShiroUser loginUser) {
        boolean state;
        long userId = (Long)MoreObjects.firstNonNull((Object)loginUser.getId(), (Object)0L);
        long processId = (Long)MoreObjects.firstNonNull((Object)process.getId(), (Object)0L);
        int unixTime = DateUtil.unixTime();
        if (processId > 0L) {
            process.setUpdater(userId);
            process.setUpdateTime(unixTime);
            int updateRows = ((ProcessMapper)this.baseMapper).updateById((Object)process);
            state = updateRows > 0;
        } else {
            process.setCreater(userId);
            process.setCreateTime(unixTime);
            process.setStatus(0);
            int insertRows = ((ProcessMapper)this.baseMapper).insert((Object)process);
            boolean bl = state = insertRows > 0;
        }
        if (!state) {
            throw new DaoException("update process has error!");
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void selectByPaging(Page<ProcessGridDTO> requestPage) {
        List<ProcessGridDTO> progresses = ((ProcessMapper)this.baseMapper).selectByPaging(requestPage);
        requestPage.setRecords(progresses);
    }

    @Override
    public boolean removeProcess(long processId) {
        int deleteRows = ((ProcessMapper)this.baseMapper).deleteById(Long.valueOf(processId));
        return deleteRows > 0;
    }

    @Override
    @Transactional
    public Form saveForm(String formDesignerData, ShiroUser shiroUser) {
        FormDesignerDto formDesignerDto;
        Preconditions.checkNotNull((Object)formDesignerData, (Object)"\u6d41\u7a0b\u8868\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            formDesignerDto = (FormDesignerDto)JSON.parseObject((String)formDesignerData, FormDesignerDto.class);
        }
        catch (Exception e) {
            LOGGER.error("parse json [{}] has error!", (Object)formDesignerData, (Object)e);
            throw new JSONException("parsejson has error!", (Throwable)e);
        }
        FormAttrDto formAttr = formDesignerDto.getAttr();
        List columnItems = formDesignerDto.getColumnItems();
        long processId = formAttr.getId();
        if (processId <= 0L) {
            LOGGER.error("\u6d41\u7a0bid\u4f20\u9012\u7a7a\u503c\u4e86\uff0c\u65e0\u6cd5\u8fdb\u884c\u5904\u7406");
            throw new ProcessBizException((ErrorCode)ProcessCode.PROCESS_ID_REQUIRED, "\u6d41\u7a0bID\u5fc5\u4f20");
        }
        Process process = (Process)((Object)((ProcessMapper)this.baseMapper).selectById(Long.valueOf(processId)));
        if (process == null) {
            throw new ProcessBizException((ErrorCode)ProcessCode.PROCESS_NOT_FOUND, "\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        try {
            Form form = this.formService.saveFormAttr(formAttr, processId, shiroUser);
            this.formDesingerService.saveFrom(formDesignerDto, formDesignerData, form);
            this.formService.saveFromColumn(columnItems, form.getId().longValue(), shiroUser);
            return form;
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u8868\u5355 [{}] \u4fe1\u606f\u51fa\u73b0\u9519\u8bef", (Object)formDesignerData, (Object)e);
            throw new ProcessBizException((ErrorCode)ProcessCode.FORM_SAVE_ERROR, "\u8868\u5355\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @Override
    @Transactional(readOnly=true)
    public FormDesinger findDesingerJSON(long processId) {
        return this.formDesingerService.selectByProcessId(processId);
    }

    @Override
    public boolean closedProcess(long processId) {
        int updateRows = ((ProcessMapper)this.baseMapper).updateColseFlagById(processId, true);
        return updateRows > 0;
    }

    @Override
    public boolean openProcess(long processId) {
        int updateRows = ((ProcessMapper)this.baseMapper).updateColseFlagById(processId, false);
        return updateRows > 0;
    }

    @Override
    @Transactional
    public boolean releaseProcess(Process process, ShiroUser shiroUser) {
        long processId = process.getId();
        ProcessDesinger processDesinger = (ProcessDesinger)((Object)this.processDesingerService.selectById(Long.valueOf(processId)));
        if (processDesinger == null) {
            throw new ProcessBizException(ProcessCode.DESIGNER_NOT_FOUND);
        }
        String processXml = processDesinger.getProcessXml();
        if (Strings.isNullOrEmpty((String)processXml)) {
            throw new ProcessBizException(ProcessCode.DESIGNER_NOT_FOUND);
        }
        String desingerJson = processDesinger.getDesingerJson();
        if (Strings.isNullOrEmpty((String)desingerJson)) {
            throw new ProcessBizException(ProcessCode.DESIGNER_NOT_FOUND);
        }
        ProcessDesingerVO desingerVO = (ProcessDesingerVO)JSON.parseObject((String)desingerJson, ProcessDesingerVO.class);
        List<ProcessNodeVO> nodeSettings = desingerVO.getNodeSettings();
        String bpmnXML = BpmnXmlUtil.destBpmnXml(processXml, nodeSettings);
        String processKey = StrUtil.format((String)"Process_{}", (Object[])new Object[]{processId});
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        Deployment deployment = deploymentBuilder.addString(processKey + ".bpmn", bpmnXML).name(processKey).deploy();
        if (deployment == null) {
            throw new ProcessBizException(ProcessCode.DEPLOYEE_FAILURE);
        }
        ProcessDefinitionQuery pdq = this.repositoryService.createProcessDefinitionQuery();
        long count = pdq.processDefinitionKey(processKey).deploymentId(deployment.getId()).count();
        if (count > 0L) {
            long shiroUserId = shiroUser.getId();
            process.setUpdateTime(DateUtil.unixTime());
            process.setUpdater(shiroUserId);
            process.setFlowId(processKey);
            process.setStatus(1);
            int updateRows = ((ProcessMapper)this.baseMapper).updateById((Object)process);
            if (updateRows <= 0) {
                throw new DaoException("\u5904\u7406\u8def\u7a0b\u53d1\u5e03\u5931\u8d25");
            }
            return true;
        }
        throw new ProcessBizException(ProcessCode.DEPLOYEE_FAILURE);
    }

    @Override
    public void exportDiagramToFile(long processId, String destFilePath) {
        String processKey = StrUtil.format((String)"Process_{}", (Object[])new Object[]{processId});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        String diagramName = processDefinition.getDiagramResourceName();
        int version = processDefinition.getVersion();
        String diagramRelativeFilePath = StrUtil.format((String)ProcessConst.DIAGRAM_PATH, (Object[])new Object[]{processKey, version, diagramName});
        String diagramFilePath = FilePathUtil.contact((String)destFilePath, (String[])new String[]{diagramRelativeFilePath});
        File diagramFile = new File(diagramFilePath);
        if (!diagramFile.exists()) {
            try {
                Files.createParentDirs((File)diagramFile);
            }
            catch (IOException e) {
                LOGGER.error("\u521b\u5efa\u6d41\u7a0b\u56fe\u5931\u8d25!", (Throwable)e);
                throw new NullPointerException("\u6d41\u7a0b\u56fe\u521b\u5efa\u5931\u8d25");
            }
        }
        try {
            String deploymentId = processDefinition.getDeploymentId();
            InputStream resourceAsStream = this.repositoryService.getResourceAsStream(deploymentId, diagramName);
            FileCopyUtils.copy((InputStream)resourceAsStream, (OutputStream)new FileOutputStream(diagramFile));
        }
        catch (IOException e) {
            LOGGER.error("\u6d41\u7a0b\u56fe\u8f6c\u6362\u56fe\u7247\u53d1\u751f\u9519\u8bef!", (Throwable)e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<ProcessGridDTO> selectAll() {
        return ((ProcessMapper)this.baseMapper).selectByStatus(1);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ProcessListVO> selectWithList() {
        List<ProcessGridDTO> processGridDTOS = this.selectAll();
        if (CollectionUtil.isEmpty(processGridDTOS)) {
            return Collections.emptyList();
        }
        ArrayList processListVOS = Lists.newArrayListWithCapacity((int)processGridDTOS.size());
        for (ProcessGridDTO processGridDTO : processGridDTOS) {
            ProcessListVO processListVO = ProcessListVO.build(processGridDTO);
            processListVOS.add(processListVO);
        }
        return processListVOS;
    }

    @Override
    public ProcessDetailDTO selectDetailById(long processId) {
        return ((ProcessMapper)this.baseMapper).selectDetailById(processId);
    }
}

