/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.process.dao.ProcessTypeMapper;
import com.jtech.toa.process.domain.ProcessType;
import com.jtech.toa.process.model.dto.ProcessGridDTO;
import com.jtech.toa.process.model.vo.ProcessTypeVO;
import com.jtech.toa.process.model.vo.ProcessVO;
import com.jtech.toa.process.service.IProcessService;
import com.jtech.toa.process.service.IProcessTypeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessTypeServiceImpl
extends ServiceImpl<ProcessTypeMapper, ProcessType>
implements IProcessTypeService {
    private static final Function<ProcessGridDTO, Long> GROUPBYTYPEFUNC = new Function<ProcessGridDTO, Long>(){

        public Long apply(ProcessGridDTO input) {
            return (Long)MoreObjects.firstNonNull((Object)input.getTypeId(), (Object)0L);
        }
    };
    private final IProcessService processService;

    @Autowired
    public ProcessTypeServiceImpl(IProcessService processService) {
        this.processService = processService;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ProcessType> selectAll() {
        return ((ProcessTypeMapper)this.baseMapper).selectByAll();
    }

    @Override
    @Transactional
    public boolean saveProcess(ProcessType processType, ShiroUser shiroUser) {
        long loginUserId = shiroUser.getId();
        long processTypeId = (Long)MoreObjects.firstNonNull((Object)processType.getId(), (Object)0L);
        int unixTime = DateUtil.unixTime();
        if (processTypeId > 0L) {
            processType.setUpdater(loginUserId);
            processType.setUpdateTime(unixTime);
            int updateRows = ((ProcessTypeMapper)this.baseMapper).updateById((Object)processType);
            return updateRows > 0;
        }
        processType.setCreater(loginUserId);
        processType.setCreateTime(unixTime);
        int insertRows = ((ProcessTypeMapper)this.baseMapper).insert((Object)processType);
        return insertRows > 0;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ProcessTypeVO> selectAllWithTypeGroup() {
        List<ProcessType> processTypes = this.selectAll();
        if (CollectionUtil.isNotEmpty(processTypes)) {
            int processTypeSize = processTypes.size();
            ArrayList types = Lists.newArrayListWithCapacity((int)processTypeSize);
            List<ProcessGridDTO> processes = this.processService.selectAll();
            if (CollectionUtil.isNotEmpty(processes)) {
                ImmutableMap groupTypeProcess = Multimaps.index(processes, GROUPBYTYPEFUNC).asMap();
                for (ProcessType processType : processTypes) {
                    long typeId = (Long)MoreObjects.firstNonNull((Object)processType.getId(), (Object)0L);
                    Collection elements = (Collection)groupTypeProcess.get(typeId);
                    ArrayList processList = Lists.newArrayList();
                    if (CollectionUtil.isNotEmpty((Collection)elements)) {
                        for (ProcessGridDTO element : elements) {
                            ProcessVO processVO = ProcessVO.build(element);
                            processList.add(processVO);
                        }
                    }
                    ProcessTypeVO processTypeVO = this.voProcessType(processType, typeId);
                    processTypeVO.setFlows(processList);
                    types.add(processTypeVO);
                }
            } else {
                for (ProcessType processType : processTypes) {
                    long typeId = (Long)MoreObjects.firstNonNull((Object)processType.getId(), (Object)0L);
                    ProcessTypeVO processTypeVO = this.voProcessType(processType, typeId);
                    types.add(processTypeVO);
                }
            }
            return types;
        }
        return Collections.emptyList();
    }

    private ProcessTypeVO voProcessType(ProcessType processType, long typeId) {
        ProcessTypeVO processTypeVO;
        if (typeId <= 0L) {
            processTypeVO = new ProcessTypeVO();
            processTypeVO.setCode("0000");
            processTypeVO.setName("\u5176\u4ed6");
        } else {
            processTypeVO = new ProcessTypeVO();
            processTypeVO.setCode(processType.getCode());
            processTypeVO.setName(processType.getName());
        }
        return processTypeVO;
    }
}

