/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.process.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.text.StrUtil;
import com.jtech.toa.process.model.vo.ProcessNodeConditionVO;
import com.jtech.toa.process.model.vo.ProcessNodeVO;
import com.jtech.toa.process.model.vo.ProcessUserVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnXmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnXmlUtil.class);
    private static final Map<String, String> NAMESPACECONTEXT = Maps.newHashMap();

    private BpmnXmlUtil() {
    }

    public static String destBpmnXml(String bpmnXml, List<ProcessNodeVO> nodeVOS) {
        Preconditions.checkNotNull((Object)bpmnXml, (Object)"xml \u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        bpmnXml = StringUtils.replace((String)bpmnXml, (String)"targetNamespace=\"http://bpmn.io/bpmn\"", (String)"targetNamespace=\"http://jtech.oa\"");
        bpmnXml = StringUtils.replace((String)bpmnXml, (String)"exporter=\"http://bpmn.io\"", (String)" xmlns:activiti=\"http://activiti.org/bpmn\"");
        bpmnXml = StringUtils.replace((String)bpmnXml, (String)"exporterVersion=\"0.10.1\"", (String)"");
        bpmnXml = StringUtils.replace((String)bpmnXml, (String)"<task ", (String)"<userTask ");
        bpmnXml = StringUtils.replace((String)bpmnXml, (String)"</task>", (String)"</userTask>");
        try {
            Document document = DocumentHelper.parseText((String)bpmnXml);
            List outgoings = (List)BpmnXmlUtil.select("//bpmn:outgoing", (Branch)document);
            for (Element outgoing : outgoings) {
                outgoing.getParent().remove(outgoing);
            }
            List incomings = (List)BpmnXmlUtil.select("//bpmn:incoming", (Branch)document);
            for (Element incoming : incomings) {
                incoming.getParent().remove(incoming);
            }
            for (ProcessNodeVO nodeVO : nodeVOS) {
                String ntype = nodeVO.getNtype();
                if (!StringUtils.equals((CharSequence)"task", (CharSequence)ntype)) continue;
                String nodeId = nodeVO.getNodeId();
                String userTaskXPath = StrUtil.format((String)"//bpmn:userTask[@id='{}']", (Object[])new Object[]{nodeId});
                Element taskNode = (Element)BpmnXmlUtil.select(userTaskXPath, (Branch)document);
                if (taskNode == null) continue;
                int approverType = nodeVO.getApproverType();
                switch (approverType) {
                    case 1: {
                        List<ProcessUserVO> assignUsers = nodeVO.getAssignUsers();
                        if (!CollectionUtil.isNotEmpty(assignUsers)) break;
                        ArrayList users = Lists.newArrayList();
                        for (ProcessUserVO assignUser : assignUsers) {
                            users.add(StrUtil.format((String)"user({})", (Object[])new Object[]{assignUser.getId()}));
                        }
                        String expressionVal = StrUtil.join((String)",", (List)users);
                        BpmnXmlUtil.addOwnerElement(taskNode, expressionVal);
                        break;
                    }
                    case 2: {
                        long assignPosition = nodeVO.getAssignPosition();
                        if (assignPosition <= 0L) break;
                        String groupFormat = StrUtil.format((String)"group({})", (Object[])new Object[]{assignPosition});
                        BpmnXmlUtil.addOwnerElement(taskNode, groupFormat);
                        break;
                    }
                    case 9: {
                        String assignFormItemWidget = nodeVO.getAssignFormItemWidget();
                        if (!StringUtils.isNotEmpty((CharSequence)assignFormItemWidget)) break;
                        String formKey = StrUtil.format((String)"${toaForm}.{}", (Object[])new Object[]{assignFormItemWidget});
                        taskNode.addAttribute("activiti:formKey", formKey);
                        break;
                    }
                    case 10: {
                        List<ProcessNodeConditionVO> conditionsItems = nodeVO.getConditionsItems();
                        if (!CollectionUtil.isNotEmpty(conditionsItems)) break;
                        taskNode.addAttribute("activiti:assignee", "${conditionUser}");
                        break;
                    }
                    case 7: {
                        taskNode.addAttribute("activiti:assignee", "${directSupervisor}");
                        break;
                    }
                }
            }
            return document.asXML();
        }
        catch (DocumentException e) {
            LOGGER.error("parse workflow document xml has error!", (Throwable)e);
            e.printStackTrace();
            return bpmnXml;
        }
    }

    private static void addOwnerElement(Element taskNode, String expressionVal) {
        Element potentialOwner = taskNode.addElement("potentialOwner");
        Element resourceAssignment = potentialOwner.addElement("resourceAssignmentExpression");
        Element formalExpression = resourceAssignment.addElement("formalExpression");
        formalExpression.addCDATA(expressionVal);
    }

    private static Object select(String expression, Branch contextNode) {
        XPath xp = contextNode.createXPath(expression);
        xp.setNamespaceURIs(NAMESPACECONTEXT);
        return xp.evaluate((Object)contextNode);
    }

    static {
        NAMESPACECONTEXT.put("bpmn", "http://www.omg.org/spec/BPMN/20100524/MODEL");
    }
}

