/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.sys.dao.AppCategoryMapper;
import com.jtech.toa.sys.domain.AppCategory;
import com.jtech.toa.sys.model.query.AppCategoryQuery;
import com.jtech.toa.sys.service.IAppCategoryService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppCategoryServiceImpl
extends ServiceImpl<AppCategoryMapper, AppCategory>
implements IAppCategoryService {
    @Override
    public List<AppCategory> selectAll() {
        return ((AppCategoryMapper)this.baseMapper).selectAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<AppCategory> findByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.absent();
        }
        AppCategory appCategory = ((AppCategoryMapper)this.baseMapper).selectByName(name);
        if (appCategory == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)appCategory));
    }

    @Override
    public boolean addAppCategory(AppCategory appCategory) {
        appCategory.setCreateTime(DateUtil.unixTime());
        appCategory.setDateline(DateUtil.unixTime());
        appCategory.setDeleteFlag(0);
        return ((AppCategoryMapper)this.baseMapper).insert((Object)appCategory) == 1;
    }

    @Override
    public boolean updateAppCategory(AppCategory appCategory) {
        appCategory.setUpdateTime(DateUtil.unixTime());
        return ((AppCategoryMapper)this.baseMapper).updateById((Object)appCategory) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<AppCategory> requestPage, AppCategoryQuery query) {
        List<AppCategory> appCategorys = ((AppCategoryMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(appCategorys);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AppCategory> findByPagination(Page<AppCategory> pageResult, List<Sort.Order> orders) {
        List<AppCategory> appCategorys = ((AppCategoryMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(appCategorys);
        return pageResult;
    }
}

