/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.sys.dao.AppMapper;
import com.jtech.toa.sys.domain.App;
import com.jtech.toa.sys.model.dto.AppDto;
import com.jtech.toa.sys.model.dto.AppListDto;
import com.jtech.toa.sys.model.query.AppQuery;
import com.jtech.toa.sys.service.IAppService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppServiceImpl
extends ServiceImpl<AppMapper, App>
implements IAppService {
    @Override
    public List<AppDto> findByType(int[] types) {
        return ((AppMapper)this.baseMapper).selectAll(types);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<App> findByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.absent();
        }
        App app = ((AppMapper)this.baseMapper).selectByName(name);
        if (app == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)app));
    }

    @Override
    public boolean addApp(AppListDto appListDto) {
        App app = appListDto.toApp();
        app.setCreateTime(DateUtil.unixTime());
        app.setAddTime(DateUtil.unixTime());
        app.setDeleteFlag(0);
        return ((AppMapper)this.baseMapper).insert((Object)app) == 1;
    }

    @Override
    public boolean updateApp(AppListDto appListDto) {
        App app = appListDto.toApp();
        app.setUpdateTime(DateUtil.unixTime());
        return ((AppMapper)this.baseMapper).updateById((Object)app) == 1;
    }

    @Override
    public boolean updateStatus(long loginUserId, long appId, int status) {
        App app = new App();
        app.setId(appId);
        app.setStatus(status);
        app.setUpdateTime(DateUtil.unixTime());
        app.setUpdater(loginUserId);
        if (status == 2) {
            app.setStopTime(DateUtil.unixTime());
        }
        return ((AppMapper)this.baseMapper).updateById((Object)app) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<AppListDto> requestPage, AppQuery query) {
        List<AppListDto> appListDtos = ((AppMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(appListDtos);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AppListDto> findByPagination(Page<AppListDto> pageResult, List<Sort.Order> orders) {
        List<AppListDto> appListDtos = ((AppMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(appListDtos);
        return pageResult;
    }

    @Override
    @Transactional(readOnly=true)
    public List<App> selectAll() {
        return ((AppMapper)this.baseMapper).selectAllApp();
    }
}

