/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.sys.dao.IconMapper;
import com.jtech.toa.sys.domain.Icon;
import com.jtech.toa.sys.model.dto.IconDto;
import com.jtech.toa.sys.model.query.IconQuery;
import com.jtech.toa.sys.model.vo.IconVO;
import com.jtech.toa.sys.service.IIconService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IconServiceImpl
extends ServiceImpl<IconMapper, Icon>
implements IIconService {
    @Override
    @Cacheable(value={"form-icon-cache"})
    public List<IconVO> finalAllWithForm() {
        List icons = ((IconMapper)this.baseMapper).selectList(null);
        if (CollectionUtil.isEmpty((Collection)icons)) {
            return Collections.emptyList();
        }
        ArrayList iconVOS = Lists.newArrayListWithCapacity((int)icons.size());
        for (Icon icon : icons) {
            IconVO iconVO = new IconVO();
            iconVO.setId(icon.getId());
            iconVO.setUrl(icon.getUrl());
            iconVO.setName(icon.getName());
            iconVOS.add(iconVO);
        }
        return iconVOS;
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Icon> findByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.absent();
        }
        Icon icon = ((IconMapper)this.baseMapper).selectByName(name);
        if (icon == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)icon));
    }

    @Override
    public boolean addIcon(IconDto iconDto) {
        Icon icon = iconDto.toIcon();
        icon.setCreateTime(DateUtil.unixTime());
        icon.setDeleteFlag(0);
        return ((IconMapper)this.baseMapper).insert((Object)icon) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<Icon> requestPage, IconQuery query) {
        List<Icon> icons = ((IconMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(icons);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Icon> findByPagination(Page<Icon> pageResult, List<Sort.Order> orders) {
        List<Icon> icons = ((IconMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(icons);
        return pageResult;
    }
}

