/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.sys.dao.ResourceMapper;
import com.jtech.toa.sys.domain.Resource;
import com.jtech.toa.sys.model.dto.ResourceDto;
import com.jtech.toa.sys.model.query.ResourceQuery;
import com.jtech.toa.sys.service.IResourceService;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceServiceImpl
extends ServiceImpl<ResourceMapper, Resource>
implements IResourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceServiceImpl.class);

    @Override
    @Transactional(readOnly=true)
    public List<Resource> selectByUser(long userId) {
        if (userId <= 0L) {
            return Collections.emptyList();
        }
        return ((ResourceMapper)this.baseMapper).selectByUserId(userId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Resource> selectAll(long id) {
        return ((ResourceMapper)this.baseMapper).selectAll(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Resource> findByName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.absent();
        }
        Resource role = ((ResourceMapper)this.baseMapper).selectByName(name);
        if (role == null) {
            LOGGER.warn("\u8d44\u6e90\u540d\u79f0{} \u67e5\u8be2\u8d44\u6e90\u4e0d\u5b58\u5728\uff01", (Object)name);
            return Optional.absent();
        }
        return Optional.of((Object)((Object)role));
    }

    @Override
    public boolean addResource(long loginUserId, ResourceDto resourceDto) {
        Resource resource = resourceDto.toResource();
        resource.setCreateTime(DateUtil.unixTime());
        resource.setCreater(loginUserId);
        resource.setDeleteFlag(0);
        return ((ResourceMapper)this.baseMapper).insert((Object)resource) == 1;
    }

    @Override
    public boolean updateResource(long loginUserId, ResourceDto resourceDto) {
        Resource resource = resourceDto.toResource();
        resource.setUpdateTime(DateUtil.unixTime());
        resource.setUpdater(loginUserId);
        return ((ResourceMapper)this.baseMapper).updateById((Object)resource) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<ResourceDto> requestPage, ResourceQuery query) {
        List<ResourceDto> resourceDtos = ((ResourceMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(resourceDtos);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<ResourceDto> findByPagination(Page<ResourceDto> pageResult, List<Sort.Order> orders) {
        List<ResourceDto> resourceDtos = ((ResourceMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(resourceDtos);
        return pageResult;
    }
}

