/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.sys.dao.RoleMapper;
import com.jtech.toa.sys.domain.Role;
import com.jtech.toa.sys.model.query.RoleQuery;
import com.jtech.toa.sys.service.IRoleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends ServiceImpl<RoleMapper, Role>
implements IRoleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleServiceImpl.class);

    @Override
    @Transactional(readOnly=true)
    public List<Role> selectAll() {
        return ((RoleMapper)this.baseMapper).selectAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Role> findByName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.absent();
        }
        Role role = ((RoleMapper)this.baseMapper).selectByName(name);
        if (role == null) {
            LOGGER.warn("\u89d2\u8272\u540d\u79f0{} \u67e5\u8be2\u89d2\u8272\u4e0d\u5b58\u5728\uff01", (Object)name);
            return Optional.absent();
        }
        return Optional.of((Object)((Object)role));
    }

    @Override
    public boolean addRole(long loginUserId, Role role) {
        role.setCreateTime(DateUtil.unixTime());
        role.setCreater(loginUserId);
        role.setDeleteFlag(0);
        return ((RoleMapper)this.baseMapper).insert((Object)role) == 1;
    }

    @Override
    public boolean updateRole(long loginUserId, Role role) {
        role.setUpdateTime(DateUtil.unixTime());
        role.setUpdater(loginUserId);
        return ((RoleMapper)this.baseMapper).updateById((Object)role) == 1;
    }

    @Override
    public boolean updateStatus(long loginUserId, long userId, int status) {
        Role role = new Role();
        role.setId(userId);
        role.setStatus(status);
        role.setUpdateTime(DateUtil.unixTime());
        role.setUpdater(loginUserId);
        return ((RoleMapper)this.baseMapper).updateById((Object)role) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<Role> requestPage, RoleQuery query) {
        List<Role> roles = ((RoleMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(roles);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Role> findByPagination(Page<Role> pageResult, List<Sort.Order> orders) {
        List<Role> roles = ((RoleMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(roles);
        return pageResult;
    }
}

