/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.sys.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.PasswordUtil;
import com.jtech.toa.sys.dao.UserMapper;
import com.jtech.toa.sys.domain.User;
import com.jtech.toa.sys.model.dto.UserDto;
import com.jtech.toa.sys.model.query.UserQuery;
import com.jtech.toa.sys.service.IRoleUserService;
import com.jtech.toa.sys.service.IUserService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
extends ServiceImpl<UserMapper, User>
implements IUserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);

    public UserServiceImpl(IRoleUserService roleUserService) {
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<User> findByUsername(String username) {
        if (Strings.isNullOrEmpty((String)username)) {
            return Optional.absent();
        }
        User user = ((UserMapper)this.baseMapper).selectByUsername(username);
        if (user == null) {
            LOGGER.warn("\u7528\u6237\u540d\u79f0{} \u67e5\u8be2\u7528\u6237\u4e0d\u5b58\u5728\uff01", (Object)username);
            return Optional.absent();
        }
        return Optional.of((Object)((Object)user));
    }

    @Override
    public Optional<User> findByUserId(long userId) {
        User user = (User)((Object)((UserMapper)this.baseMapper).selectById(Long.valueOf(userId)));
        if (user == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)user));
    }

    @Override
    public boolean addUser(long loginUserId, UserDto userDto) {
        User user = userDto.toUser();
        byte[] randomSaltBytes = PasswordUtil.generateSalt();
        String password = PasswordUtil.password((byte[])randomSaltBytes, (String)userDto.getPassword());
        String randomSalt = PasswordUtil.salt((byte[])randomSaltBytes);
        user.setPassword(password);
        user.setSalt(randomSalt);
        user.setCreateTime(DateUtil.unixTime());
        user.setCreater(loginUserId);
        user.setDeleteFlag(0);
        return ((UserMapper)this.baseMapper).insert((Object)user) == 1;
    }

    @Override
    public boolean updateUser(long loginUserId, UserDto userDto) {
        User user = userDto.toUser();
        user.setUpdateTime(DateUtil.unixTime());
        user.setUpdater(loginUserId);
        return ((UserMapper)this.baseMapper).updateById((Object)user) == 1;
    }

    @Override
    public boolean updatePassword(long loginUserId, UserDto userDto) {
        User user = new User();
        byte[] randomSaltBytes = PasswordUtil.generateSalt();
        String userPass = PasswordUtil.password((byte[])randomSaltBytes, (String)userDto.getPassword());
        String randomSalt = PasswordUtil.salt((byte[])randomSaltBytes);
        user.setPassword(userPass);
        user.setSalt(randomSalt);
        user.setId(userDto.getId());
        user.setUpdateTime(DateUtil.unixTime());
        user.setUpdater(loginUserId);
        return ((UserMapper)this.baseMapper).updateById((Object)user) == 1;
    }

    @Override
    public boolean updateStatus(long loginUserId, long userId, int status) {
        User user = new User();
        user.setId(userId);
        user.setFreezeFlag(status);
        user.setUpdateTime(DateUtil.unixTime());
        user.setUpdater(loginUserId);
        return ((UserMapper)this.baseMapper).updateById((Object)user) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<UserDto> requestPage, UserQuery query) {
        List<UserDto> userDtos = ((UserMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(userDtos);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<UserDto> findByPagination(Page<UserDto> pageResult, List<Sort.Order> orders) {
        List<UserDto> userDtos = ((UserMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(userDtos);
        return pageResult;
    }
}

