/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.user.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Optional;
import com.jtech.toa.user.model.UserToken;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private static final int TOKEN_EXPIRES_HOUR = 72;
    private static final String JWT_ISSUER = "jt@bpm#2017";
    private static final String JWT_CLAIM_USERID = "id";
    private static final String JWT_CLAIM_USERNAME = "name";
    private static final String KEY_TOKEN_BPS = "bps:token:%d";
    private final RedisTemplate<String, String> redis;
    private final Algorithm algorithmHS;

    @Autowired
    public TokenService(RedisTemplate<String, String> redisTemplate) {
        this.redis = redisTemplate;
        try {
            this.algorithmHS = Algorithm.HMAC256((String)"t-io@2017");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("create user Token has error!");
        }
    }

    public UserToken createToken(int userId, String name) {
        String token = JWT.create().withIssuer(JWT_ISSUER).withClaim(JWT_CLAIM_USERID, Integer.valueOf(userId)).withClaim(JWT_CLAIM_USERNAME, name).sign(this.algorithmHS);
        UserToken model = new UserToken();
        model.setUserId(userId);
        String tokenKey = String.format(KEY_TOKEN_BPS, userId);
        this.redis.boundValueOps((Object)tokenKey).set((Object)token, 72L, TimeUnit.HOURS);
        model.setName(name);
        model.setToken(token);
        return model;
    }

    public boolean checkToken(UserToken model) {
        if (model == null) {
            return false;
        }
        int redisCackUserId = model.getUserId();
        String redisCacheKey = String.format(KEY_TOKEN_BPS, redisCackUserId);
        String token = (String)this.redis.boundValueOps((Object)redisCacheKey).get();
        if (token == null || !token.equals(model.getToken())) {
            return false;
        }
        JWTVerifier verifier = JWT.require((Algorithm)this.algorithmHS).withIssuer(JWT_ISSUER).build();
        DecodedJWT jwt = verifier.verify(token);
        Integer userId = jwt.getClaim(JWT_CLAIM_USERID).asInt();
        if (userId == null || userId <= 0) {
            return false;
        }
        if (userId != redisCackUserId) {
            return false;
        }
        this.redis.boundValueOps((Object)redisCacheKey).expire(72L, TimeUnit.HOURS);
        return true;
    }

    public Optional<UserToken> getToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        JWTVerifier verifier = JWT.require((Algorithm)this.algorithmHS).withIssuer(JWT_ISSUER).build();
        DecodedJWT jwt = verifier.verify(token);
        Integer userId = jwt.getClaim(JWT_CLAIM_USERID).asInt();
        if (userId == null || userId <= 0) {
            return Optional.absent();
        }
        String redisCacheKey = String.format(KEY_TOKEN_BPS, userId);
        String cacheToken = (String)this.redis.boundValueOps((Object)redisCacheKey).get();
        if (org.springframework.util.StringUtils.isEmpty((Object)cacheToken)) {
            return Optional.absent();
        }
        if (!StringUtils.equals((CharSequence)token, (CharSequence)cacheToken)) {
            return Optional.absent();
        }
        String username = jwt.getClaim(JWT_CLAIM_USERNAME).asString();
        UserToken userToken = new UserToken();
        userToken.setUserId(userId);
        userToken.setToken(token);
        userToken.setName(username);
        return Optional.of((Object)userToken);
    }

    public void deleteToken(int userId) {
        String redisCacheKey = String.format(KEY_TOKEN_BPS, userId);
        this.redis.delete((Object)redisCacheKey);
    }
}

