/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.user.service.impl;

import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.vo.ZTreeVO;
import com.jtech.toa.user.dao.OrganizationMapper;
import com.jtech.toa.user.domain.Organization;
import com.jtech.toa.user.domain.OrganizationChildren;
import com.jtech.toa.user.model.OrganizationChartDto;
import com.jtech.toa.user.model.vo.DesingerOrganizationVO;
import com.jtech.toa.user.service.IEmployeeOrganizationService;
import com.jtech.toa.user.service.IOrganizationChildrenService;
import com.jtech.toa.user.service.IOrganizationEmployeeService;
import com.jtech.toa.user.service.IOrganizationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachePut;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class OrganizationService
extends ServiceImpl<OrganizationMapper, Organization>
implements IOrganizationService {
    private final IOrganizationChildrenService organizationChildrenService;
    private final IOrganizationEmployeeService organizationEmployeeService;
    private final IEmployeeOrganizationService employeeOrganizationService;

    @Autowired
    public OrganizationService(IOrganizationChildrenService organizationChildrenService, IOrganizationEmployeeService organizationEmployeeService, IEmployeeOrganizationService employeeOrganizationService) {
        this.organizationChildrenService = organizationChildrenService;
        this.organizationEmployeeService = organizationEmployeeService;
        this.employeeOrganizationService = employeeOrganizationService;
    }

    private static List<ZTreeVO<Organization>> listToZtree(List<Organization> organizations) {
        int organizationSize = organizations.size();
        ArrayList zTreeVOList = Lists.newArrayListWithCapacity((int)organizationSize);
        for (Organization organization : organizations) {
            ZTreeVO zTreeVO = ZTreeVO.builder().data((Serializable)organization).id(organization.getId()).pid(organization.getParentId()).name(organization.getName()).build();
            zTreeVOList.add(zTreeVO);
        }
        return zTreeVOList;
    }

    @Override
    public Organization selectById(int id) {
        return (Organization)((OrganizationMapper)this.baseMapper).selectById(Integer.valueOf(id));
    }

    @Override
    public OrganizationChartDto findAllToChart() {
        List<OrganizationChartDto> organizations = ((OrganizationMapper)this.baseMapper).findAllToTreeNode();
        ArrayList<OrganizationChartDto> trees = new ArrayList<OrganizationChartDto>();
        for (OrganizationChartDto organizationChartDto : organizations) {
            if (organizationChartDto.getPid() == 0L) {
                trees.add(organizationChartDto);
            }
            for (OrganizationChartDto it : organizations) {
                if (it.getPid().longValue() != organizationChartDto.getId()) continue;
                if (organizationChartDto.getChildrens() == null) {
                    organizationChartDto.setChildrens(new ArrayList<OrganizationChartDto>());
                }
                organizationChartDto.getChildrens().add(it);
            }
        }
        OrganizationChartDto organizationChartDto = new OrganizationChartDto();
        organizationChartDto.setId(0L);
        organizationChartDto.setPid(null);
        organizationChartDto.setName("\u7ec4\u7ec7\u7ed3\u6784\u6811");
        organizationChartDto.setChildrens(trees);
        return organizationChartDto;
    }

    @Override
    public List<ZTreeVO<Organization>> findAllToTree(String likeName) {
        if (Strings.isNullOrEmpty((String)likeName)) {
            return this.generateOrgTree();
        }
        return this.generateOrgTreeByName(likeName);
    }

    @Override
    public List<Organization> findAll() {
        return ((OrganizationMapper)this.baseMapper).findAll();
    }

    @Override
    public List<ZTreeVO<Organization>> generateOrgTree() {
        List<Organization> organizations = ((OrganizationMapper)this.baseMapper).findAll();
        if (CollectionUtil.isEmpty(organizations)) {
            return Collections.emptyList();
        }
        return OrganizationService.listToZtree(organizations);
    }

    @Override
    public List<ZTreeVO<Organization>> generateOrgTreeByName(String name) {
        Wrapper condition = Condition.create().like("name", name);
        List organizations = this.selectList(condition);
        if (CollectionUtil.isEmpty((Collection)organizations)) {
            return Collections.emptyList();
        }
        return OrganizationService.listToZtree(organizations);
    }

    @Override
    @Transactional
    public boolean add(Organization organization) {
        organization.setId(null);
        organization.setCreateTime(DateUtil.unixTime());
        organization.setUpdateTime(DateUtil.unixTime());
        organization.setDeleteFlag(0);
        long parentId = organization.getParentId();
        organization.setLevel(this.getLevel(parentId));
        organization.setHasChildren(0);
        organization.setStatus(0);
        if (organization.getHeadEmployeeId() == null) {
            organization.setHeadEmployeeId(0L);
        }
        try {
            organization.setDomain(PinyinHelper.convertToPinyinString((String)organization.getName(), (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE));
        }
        catch (PinyinException e) {
            e.printStackTrace();
        }
        int rows = ((OrganizationMapper)this.baseMapper).insert(organization);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        rows = this.organizationChildrenService.addToChildren(parentId, organization.getId(), organization.getLevel());
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    public Organization findById(long id) {
        return (Organization)((OrganizationMapper)this.baseMapper).selectById(Long.valueOf(id));
    }

    @Override
    @Transactional
    @CachePut(value={"form-orgs-cache"})
    public boolean updateInfo(Organization organization) {
        long parentId = organization.getParentId();
        organization.setParentId(parentId);
        organization.setLevel(this.getLevel(parentId));
        organization.setDeleteFlag(0);
        organization.setUpdateTime(DateUtil.unixTime());
        try {
            organization.setDomain(PinyinHelper.convertToPinyinString((String)organization.getName(), (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE));
        }
        catch (PinyinException e) {
            e.printStackTrace();
        }
        organization.setSimpleName(organization.getSimpleName());
        int rows = ((OrganizationMapper)this.baseMapper).updateInfoById(organization);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        rows = this.organizationChildrenService.deleteByChildrenOrgId(organization.getId());
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        rows = this.organizationChildrenService.addToChildren(parentId, organization.getId(), organization.getLevel());
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    @CachePut(value={"form-orgs-cache"})
    public boolean deleteById(Integer id) {
        int rows = ((OrganizationMapper)this.baseMapper).updateDeleteFlag(id.intValue());
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    public boolean updateStatus(long orgId, int status) {
        Organization organization = new Organization();
        organization.setStatus(status);
        organization.setId(orgId);
        int rows = ((OrganizationMapper)this.baseMapper).updateInfoById(organization);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    public int countEmployee(long id) {
        return ((OrganizationMapper)this.baseMapper).selectEmployeeCount(id);
    }

    @Override
    @Transactional
    @CachePut(value={"form-orgs-cache"})
    public boolean plusEmployee(List<Long> newEmployeeIds, long orgId) {
        Organization organization = this.findById(orgId);
        int originalEmployeeSize = organization.getEmployeeSize();
        int rows = this.employeeOrganizationService.deleteByOrgIdAndEmployeeId(newEmployeeIds, orgId);
        if (rows < 0) {
            throw new DaoException("delete employee_organization error");
        }
        rows = this.organizationEmployeeService.deleteByOrgIdAndEmployeeIds(newEmployeeIds, orgId);
        if (rows < 0) {
            throw new DaoException("delete organization_employee error");
        }
        rows = this.organizationEmployeeService.deleteByChildrenOrgIdAndEmployeeIds(newEmployeeIds, orgId);
        if (rows < 0) {
            throw new DaoException("delete organization_employee error");
        }
        boolean res = this.employeeOrganizationService.insertList(newEmployeeIds, orgId);
        if (!res) {
            throw new DaoException("insert employee_organization error");
        }
        res = this.organizationEmployeeService.insertList(newEmployeeIds, orgId);
        if (!res) {
            throw new DaoException("insert employee_organization error");
        }
        int currentEmployeeSize = this.organizationEmployeeService.selectCount(Condition.create().eq("organization_id", (Object)orgId));
        int changeSize = currentEmployeeSize - originalEmployeeSize;
        rows = this.updateEmployeeSizeByOrgIdWithChangeSize(orgId, changeSize);
        if (rows <= 0) {
            throw new DaoException("update organization error");
        }
        return true;
    }

    private int updateEmployeeSizeByOrgIdWithChangeSize(long orgId, int changeSize) {
        List<OrganizationChildren> organizationChildrens = this.organizationChildrenService.selectByChildren(orgId);
        ArrayList ids = Lists.newArrayList();
        for (OrganizationChildren organizationChildren : organizationChildrens) {
            ids.add(organizationChildren.getOrganizationId());
        }
        ids.add(orgId);
        return ((OrganizationMapper)this.baseMapper).updateEmployeeSizeByIds(ids, changeSize);
    }

    @Override
    @CachePut(value={"form-orgs-cache"})
    public boolean removeEmployee(List<Long> removeEmployeeIds, long orgId) {
        int removeSize = removeEmployeeIds.size() * -1;
        int rows = this.updateEmployeeSizeByOrgIdWithChangeSize(orgId, removeSize);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        rows = this.employeeOrganizationService.deleteByOrgIdAndEmployeeId(removeEmployeeIds, orgId);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        rows = this.organizationEmployeeService.deleteByOrgIdAndEmployeeIds(removeEmployeeIds, orgId);
        if (rows < 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    @CachePut(value={"form-orgs-cache"})
    public boolean moveEmployee(long empId, long orgId, long destOrgId) {
        return this.removeEmployee(Lists.newArrayList((Object[])new Long[]{empId}), orgId) && this.plusEmployee(Lists.newArrayList((Object[])new Long[]{empId}), destOrgId);
    }

    private int getLevel(long parentId) {
        if (parentId != 0L) {
            Organization parentOrg = this.findById(parentId);
            if (parentOrg != null) {
                return parentOrg.getLevel() + 1;
            }
            return 1;
        }
        return 1;
    }

    @Override
    public List<DesingerOrganizationVO> findAllByDesinger() {
        List<Organization> organizations = ((OrganizationMapper)this.baseMapper).findAll();
        if (CollectionUtil.isEmpty(organizations)) {
            return Collections.emptyList();
        }
        ArrayList organizationVOS = Lists.newArrayListWithCapacity((int)organizations.size());
        DesingerOrganizationVO first = new DesingerOrganizationVO();
        first.setDepartmentId(0L);
        first.setName("\u7ec4\u7ec7\u673a\u6784\u6811");
        first.setParentId(0L);
        first.setOpen(true);
        organizationVOS.add(first);
        for (Organization organization : organizations) {
            DesingerOrganizationVO desingerOrganizationVO = new DesingerOrganizationVO();
            desingerOrganizationVO.setDepartmentId(organization.getId());
            desingerOrganizationVO.setParentId(organization.getParentId());
            desingerOrganizationVO.setName(organization.getName());
            int level = (Integer)MoreObjects.firstNonNull((Object)organization.getLevel(), (Object)0);
            desingerOrganizationVO.setOpen(level == 0);
            organizationVOS.add(desingerOrganizationVO);
        }
        return organizationVOS;
    }

    @Override
    public List<Organization> findByParentId(long parentId) {
        return ((OrganizationMapper)this.baseMapper).findByParentId(parentId);
    }
}

