/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.awt.Color;
import java.util.List;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.headertoolbar.actions.EditColumnHeaderData;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.web.commands.Command;

public class EditColumnHeaderCommand
implements Command {
    private StandardTable table;
    private EditColumnHeaderData editColumnHeaderData;
    private EditColumnHeaderData oldEditColumnHeaderData;
    private JRDesignTextElement textElement;
    private String oldText;

    public EditColumnHeaderCommand(StandardTable table, EditColumnHeaderData editColumnHeaderData) {
        this.table = table;
        this.editColumnHeaderData = editColumnHeaderData;
    }

    @Override
    public void execute() {
        List<BaseColumn> tableColumns = TableUtil.getAllColumns(this.table);
        StandardColumn column = (StandardColumn)tableColumns.get(this.editColumnHeaderData.getColumnIndex());
        this.textElement = TableUtil.getColumnHeaderTextElement(column);
        if (this.textElement != null) {
            this.oldEditColumnHeaderData = new EditColumnHeaderData();
            HeaderToolbarElementUtils.copyOwnTextElementStyle(this.oldEditColumnHeaderData, this.textElement);
            this.applyColumnHeaderData(this.editColumnHeaderData, this.textElement, true);
        }
    }

    private void applyColumnHeaderData(EditColumnHeaderData headerData, JRDesignTextElement textElement, boolean execute) {
        if (textElement instanceof JRDesignTextField) {
            JRDesignTextField designTextField = (JRDesignTextField)textElement;
            if (execute) {
                if (this.oldText == null) {
                    this.oldText = ((JRDesignExpression)designTextField.getExpression()).getText();
                }
                ((JRDesignExpression)designTextField.getExpression()).setText("\"" + JRStringUtil.escapeJavaStringLiteral(headerData.getHeadingName()) + "\"");
            } else {
                ((JRDesignExpression)designTextField.getExpression()).setText(this.oldText);
            }
        } else if (textElement instanceof JRDesignStaticText) {
            JRDesignStaticText staticText = (JRDesignStaticText)textElement;
            if (execute) {
                if (this.oldText == null) {
                    this.oldText = staticText.getText();
                }
                staticText.setText(headerData.getHeadingName());
            } else {
                staticText.setText(this.oldText);
            }
        }
        textElement.setFontName(headerData.getFontName());
        textElement.setFontSize(headerData.getFontSize() != null ? Integer.valueOf(headerData.getFontSize()) : null);
        textElement.setBold(headerData.getFontBold());
        textElement.setItalic(headerData.getFontItalic());
        textElement.setUnderline(headerData.getFontUnderline());
        textElement.setForecolor(headerData.getFontColor() != null ? JRColorUtil.getColor("#" + headerData.getFontColor(), textElement.getForecolor()) : null);
        textElement.setHorizontalAlignment(HorizontalAlignEnum.getByName(headerData.getFontHAlign()));
        textElement.setBackcolor(headerData.getFontBackColor() != null ? JRColorUtil.getColor("#" + headerData.getFontBackColor(), Color.white) : null);
        textElement.setMode(ModeEnum.getByName(headerData.getMode()));
    }

    @Override
    public void undo() {
        if (this.oldEditColumnHeaderData != null) {
            this.applyColumnHeaderData(this.oldEditColumnHeaderData, this.textElement, false);
        }
    }

    @Override
    public void redo() {
        this.applyColumnHeaderData(this.editColumnHeaderData, this.textElement, true);
    }
}

