/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.framework.content.interceptor;

import com.kintiger.platform.framework.annotations.Decode;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.ParametersInterceptor;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.Map;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class DecodeParametersInterceptor
extends ParametersInterceptor {
    private static final long serialVersionUID = 6484320257843908148L;
    private static final Log logger = LogFactory.getLog(DecodeParametersInterceptor.class);
    private static final ThreadLocal<Boolean> encoded = new ThreadLocal();

    static {
        OgnlRuntime.setPropertyAccessor(Object.class, (PropertyAccessor)DecodeParametersInterceptor.getObjectAccessor());
    }

    public static boolean isEncoded() {
        return encoded.get() == null ? false : encoded.get();
    }

    public static void setEncoded(boolean value) {
        encoded.set(value);
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
        encoded.set(null);
        encoded.remove();
    }

    protected void before(ActionInvocation invocation) throws Exception {
        DecodeParametersInterceptor.setEncoded("XMLHttpRequest".equalsIgnoreCase(ServletActionContext.getRequest().getHeader("x-requested-with")));
    }

    private static final PropertyAccessor getObjectAccessor() {
        return new ObjectPropertyAccessor(){

            public void setProperty(Map context, Object target, Object oname, Object value) throws OgnlException {
                DecodeParametersInterceptor.setEncoded("XMLHttpRequest".equalsIgnoreCase(ServletActionContext.getRequest().getHeader("x-requested-with")));
                if (DecodeParametersInterceptor.isEncoded()) {
                    try {
                        boolean decode = target.getClass().isAnnotationPresent(Decode.class);
                        boolean bl = decode = decode || this.getDeclaredField(target.getClass(), (String)oname).isAnnotationPresent(Decode.class);
                        if (decode) {
                            String[] tmp = value == null ? new String[]{} : (String[])value;
                            int i = 0;
                            int len = tmp.length;
                            while (i < len) {
                                if (tmp[i] != null) {
                                    tmp[i] = URLDecoder.decode(tmp[i], "UTF-8");
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
                super.setProperty(context, target, oname, value);
                encoded.set(null);
                encoded.remove();
            }

            private Field getDeclaredField(Class target, String name) {
                if (target == null) {
                    return null;
                }
                try {
                    return target.getDeclaredField(name);
                }
                catch (Exception e) {
                    return this.getDeclaredField(target.getSuperclass(), name);
                }
            }
        };
    }
}

