/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.framework.cookie;

import com.kintiger.platform.base.pojo.Encrypter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CookieManagerBase {
    private static final Log log = LogFactory.getLog(CookieManagerBase.class);
    protected static final int MAX_COOKIE_AGE = 999999999;
    protected static final int TEMP_COOKIE_AGE = -1;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String domain;
    private final String path;

    public CookieManagerBase(HttpServletRequest request, HttpServletResponse response, String domain, String path) {
        this.request = request;
        this.response = response;
        this.domain = domain;
        this.path = path;
    }

    private Map parseCookie(String cookieName) {
        HashMap<String, String> valueMap = (HashMap<String, String>)this.request.getAttribute(cookieName);
        if (valueMap != null) {
            return valueMap;
        }
        valueMap = new HashMap<String, String>();
        this.request.setAttribute(cookieName, valueMap);
        String cookieValue = this.getDecryptedCookieValue(cookieName);
        if (StringUtils.isEmpty((String)cookieValue)) {
            return valueMap;
        }
        String[] kvPairs = cookieValue.split("&");
        int i = 0;
        while (i < kvPairs.length) {
            int offset;
            if (!StringUtils.isEmpty((String)kvPairs[i]) && (offset = kvPairs[i].indexOf(61)) > 0) {
                String key = kvPairs[i].substring(0, offset);
                String value = kvPairs[i].substring(offset + 1);
                if (!StringUtils.isEmpty((String)key) && !StringUtils.isEmpty((String)value)) {
                    try {
                        valueMap.put(key, URLDecoder.decode(value, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ex) {
                        log.error((Object)("failed to decode cookie value: " + value), (Throwable)ex);
                    }
                }
            }
            ++i;
        }
        return valueMap;
    }

    private String getDecryptedCookieValue(String cookieName) {
        String cookieValue = this.getCookieValue(cookieName, null);
        if (cookieValue == null) {
            return null;
        }
        try {
            String decodedValue = URLDecoder.decode(cookieValue, "ISO-8859-1");
            return new String(new Encrypter().decrypt(decodedValue.getBytes("ISO-8859-1")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("failed to decrypt cookie value: " + cookieValue), (Throwable)e);
            return null;
        }
    }

    private String getCookieValue(String cookieName, String defaultValue) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookieName.equals(cookie.getName())) {
                    return cookie.getValue();
                }
                ++i;
            }
        }
        return defaultValue;
    }

    private void addEncryptedCookie(String cookieName, String cookieValue, int age) {
        String encryptedValue;
        try {
            encryptedValue = new String(new Encrypter().encrypt(cookieValue.getBytes("UTF-8")), "ISO-8859-1");
            encryptedValue = URLEncoder.encode(encryptedValue, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("failed to encrypt cookie value: " + cookieValue), (Throwable)e);
            return;
        }
        Cookie cookie = new Cookie(cookieName, encryptedValue);
        cookie.setMaxAge(age);
        if (!StringUtils.isBlank((String)this.path)) {
            cookie.setPath(this.path);
        }
        if (!StringUtils.isBlank((String)this.domain)) {
            cookie.setDomain(this.domain);
        }
        this.response.addCookie(cookie);
    }

    protected String getValue(String cookieName, String key) {
        return this.getValue(cookieName, key, null);
    }

    protected String getValue(String cookieName, String key, String defaultValue) {
        Map valueMap = this.parseCookie(cookieName);
        String value = (String)valueMap.get(key);
        return StringUtils.isEmpty((String)value) ? defaultValue : value;
    }

    protected void setValue(String cookieName, String key, String value) {
        Map valueMap = this.parseCookie(cookieName);
        if (!StringUtils.isEmpty((String)value)) {
            valueMap.put(key, value);
        } else {
            valueMap.remove(key);
        }
    }

    protected void save(String cookieName, int age) {
        Map valueMap = this.parseCookie(cookieName);
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : valueMap.entrySet()) {
            String value;
            String key = (String)e.getKey();
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)(value = (String)e.getValue()))) continue;
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(key);
            sb.append('=');
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                log.error((Object)("failed to encode cookie value: " + value), (Throwable)ex);
            }
        }
        this.addEncryptedCookie(cookieName, sb.toString(), age);
    }

    protected void remove(String cookieName) {
        this.save(cookieName, 0);
    }
}

