/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.framework.perf4j;

import com.kintiger.platform.record.pojo.HessianDetail;
import com.kintiger.platform.record.pojo.HessianTotal;
import com.kintiger.platform.record.serviceNotProxy.IHessianService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;

public class WatchInterface {
    private Map<String, StopWatch> watchs = new HashMap<String, StopWatch>();
    private StopWatch stopWatch;
    private IHessianService hessianService;
    String hessianName;
    HessianTotal t;
    HessianDetail d;
    private int pk;

    public void doBefore(JoinPoint jp) throws Exception {
        String watchName = String.valueOf(jp.getTarget().getClass().getName().split("\\.")[6]) + "." + jp.getSignature().getName();
        this.hessianName = String.valueOf(jp.getTarget().getClass().getName()) + "." + jp.getSignature().getName();
        if (this.watchs.containsKey(watchName)) {
            this.stopWatch = this.watchs.get(watchName);
        } else {
            this.stopWatch = new Slf4JStopWatch(watchName);
            this.watchs.put(watchName, this.stopWatch);
        }
        this.stopWatch.start();
        this.t = this.hessianService.searchHessian(this.hessianName);
        if (this.t == null) {
            this.t = new HessianTotal();
            this.t.setHessianName(this.hessianName);
            this.t.setHessianState("Y");
            this.t.setCreateDate(new Date());
            this.pk = this.hessianService.addHessian(this.t);
            this.t = null;
        } else if ("N".equals(this.t.getHessianState())) {
            throw new Exception();
        }
    }

    public void doAfter(JoinPoint jp) {
        String watchName = String.valueOf(jp.getTarget().getClass().getName().split("\\.")[6]) + "." + jp.getSignature().getName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.watchs.containsKey(watchName)) {
            this.stopWatch = this.watchs.get(watchName);
            this.d = new HessianDetail();
            this.d.setTotalId(this.t == null ? this.pk : this.t.getId());
            this.d.setRecordDate(sdf.format(new Date()));
            HessianDetail detail = this.hessianService.searchHessianDetail(this.d);
            if (detail == null) {
                this.d.setCount(1L);
            } else {
                this.d.setId(detail.getId());
                this.d.setCount(detail.getCount() + 1L);
            }
            this.hessianService.addOrUpdateHessianDetail(this.d);
            this.stopWatch.stop();
        }
    }

    public IHessianService getHessianService() {
        return this.hessianService;
    }

    public void setHessianService(IHessianService hessianService) {
        this.hessianService = hessianService;
    }

    public String getHessianName() {
        return this.hessianName;
    }

    public void setHessianName(String hessianName) {
        this.hessianName = hessianName;
    }
}

