/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.framework.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DateUtil {
    private static final long MILLISECONDS_A_DAY = 86400000L;
    private static final long MILLISECONDS_A_HOUR = 3600000L;
    private static final long MILLISECONDS_A_MINUTE = 3600000L;
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static Logger logger = Logger.getLogger(DateUtil.class);
    private static final String DEFAULT_DATEFULLTIME_FORMAT = "yyyyMMddHHmmss";
    public static final String DEFAULT_DATEFULLDATE_FORMAT = "yyyyMMdd";
    public static final String DEFAULT_YEAR_FORMAT = "yyyy";
    public static final String DEFAULT_MONTH_FORMAT = "MM";
    private static final Pattern pattern = Pattern.compile("(?:(?:19|20)\\d{2})-(?:0?[1-9]|1[0-2])-(?:0?[1-9]|[12][0-9]|3[01])");

    public static Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addMinutes(Date date, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, minute);
        return cal.getTime();
    }

    public static Date parseDate(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return format.parse(s);
    }

    public static Date addMonths(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date getMaxDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static int getYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2) + 1;
    }

    public static Date getMinDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getMinDateByMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getMaxDateByMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getLastDayOfLastMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date addYears(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static String datetime(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static String datetime(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String datetime(String date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String date(Date date, String format) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String date(String dateStr, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(dateStr);
    }

    public static String getNowDateStr() {
        return DateUtil.getNowDatetimeStr(DEFAULT_DATE_FORMAT);
    }

    public static String getNowDatetimeStr() {
        return DateUtil.getNowDatetimeStr(DEFAULT_DATETIME_FORMAT);
    }

    public static String getNowDateminStr() {
        return DateUtil.getNowDatetimeStr(DEFAULT_DATEFULLTIME_FORMAT);
    }

    public static String getNowDatetimeStr(String format) {
        Calendar cal = Calendar.getInstance();
        return DateUtil.datetime(cal.getTime(), format);
    }

    public static Date dateOnly(Date date) {
        return new Date(date.getTime() / 86400000L);
    }

    public static Date dateOnlyExt(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date dateMinTime(Date date) {
        return DateUtil.dateOnlyExt(date);
    }

    public static String getStandDateTimeStr(String dateTimeStr) {
        if (dateTimeStr == null || "".equals(dateTimeStr)) {
            return "";
        }
        dateTimeStr = dateTimeStr.replaceAll("\\s+", "|");
        String[] a = dateTimeStr.split("\\|");
        List<String> list = Arrays.asList(a);
        String datetime = "";
        int count = 1;
        int i = 0;
        while (i < list.size()) {
            String temp = list.get(i);
            StringTokenizer st = i == 0 ? new StringTokenizer(temp, "-") : new StringTokenizer(temp, ":");
            int k = st.countTokens();
            int j = 0;
            while (j < k) {
                String sttemp = (String)st.nextElement();
                if (count == 1) {
                    datetime = sttemp;
                } else {
                    if (sttemp.equals("0") || sttemp.equals("00")) {
                        sttemp = "0";
                    } else if (Integer.valueOf(sttemp) < 10) {
                        sttemp = sttemp.replaceAll("0", "");
                    }
                    if (count < 4) {
                        datetime = Integer.valueOf(sttemp) < 10 ? String.valueOf(datetime) + "-0" + sttemp : String.valueOf(datetime) + "-" + sttemp;
                    }
                    if (count == 4) {
                        datetime = Integer.valueOf(sttemp) < 10 ? String.valueOf(datetime) + " 0" + sttemp : String.valueOf(datetime) + " " + sttemp;
                    }
                    if (count > 4) {
                        datetime = Integer.valueOf(sttemp) < 10 ? String.valueOf(datetime) + ":0" + sttemp : String.valueOf(datetime) + ":" + sttemp;
                    }
                }
                ++count;
                ++j;
            }
            ++i;
        }
        try {
            Date test = DateUtil.getDateFromStr(datetime);
            return datetime;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Date getDateFromStr(String datetime) {
        if (datetime == null || "".equals(datetime)) {
            return new Date();
        }
        String nyr = datetime.trim();
        nyr = nyr.indexOf(" ") > 0 ? nyr.substring(0, nyr.indexOf(" ")) : nyr.substring(0, nyr.length());
        StringTokenizer st = new StringTokenizer(nyr, "-");
        Date date = new Date();
        String temp = "";
        int count = st.countTokens();
        int i = 0;
        while (i < count) {
            temp = (String)st.nextElement();
            if (i == 0) {
                date.setYear(Integer.parseInt(temp) - 1900);
            }
            if (i == 1) {
                date.setMonth(Integer.parseInt(temp) - 1);
            }
            if (i == 2) {
                date.setDate(Integer.parseInt(temp));
            }
            ++i;
        }
        if (datetime.length() > 10) {
            String sfm = datetime.substring(11, 19);
            StringTokenizer st2 = new StringTokenizer(sfm, ":");
            count = st2.countTokens();
            int i2 = 0;
            while (i2 < count) {
                temp = (String)st2.nextElement();
                if (i2 == 0) {
                    date.setHours(Integer.parseInt(temp));
                }
                if (i2 == 1) {
                    date.setMinutes(Integer.parseInt(temp));
                }
                if (i2 == 2) {
                    date.setSeconds(Integer.parseInt(temp));
                }
                ++i2;
            }
        }
        return date;
    }

    public static int getQuot(Date startDate, Date endDate) {
        long quot = 0L;
        quot = endDate.getTime() - startDate.getTime();
        return (int)(quot /= 86400000L);
    }

    public static int getQuot(String startDateStr, String endDateStr, String format) {
        long quot = 0L;
        format = format != null && format.length() > 0 ? format : DEFAULT_DATE_FORMAT;
        SimpleDateFormat ft = new SimpleDateFormat(format);
        try {
            Date date1 = ft.parse(endDateStr);
            Date date2 = ft.parse(startDateStr);
            quot = date1.getTime() - date2.getTime();
            quot /= 86400000L;
        }
        catch (ParseException e) {
            logger.error((Object)"\u83b7\u53d6\u4e24\u4e2a\u65e5\u671f\u76f8\u5dee\u5929\u6570\u5f02\u5e38: ", (Throwable)e);
        }
        return (int)quot;
    }

    public static final String getDateTime(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat ymdhmsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return ymdhmsFormat.format(date);
    }

    public static final String getDateTime(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat ymdhmsFormat = new SimpleDateFormat(pattern);
        return ymdhmsFormat.format(date);
    }

    public static int getQuotHours(Date startDate, Date endDate) {
        long quot = 0L;
        quot = endDate.getTime() - startDate.getTime();
        return (int)(quot /= 3600000L);
    }

    public static Date getDateTime(String dateTime) {
        return DateUtil.getDateTime(dateTime, DEFAULT_DATE_FORMAT);
    }

    public static Date getDateTime(String dateTime, String formatPattern) {
        try {
            if (StringUtils.isNotBlank((String)dateTime) && StringUtils.isNotBlank((String)formatPattern)) {
                SimpleDateFormat format = new SimpleDateFormat(formatPattern);
                return format.parse(dateTime);
            }
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static Date getDateDetailTime(String dateTime) {
        try {
            if (StringUtils.isNotBlank((String)dateTime)) {
                SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATETIME_FORMAT);
                return format.parse(dateTime);
            }
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static long getDtSeq() {
        return System.currentTimeMillis();
    }

    public static boolean isBetween(Date min, Date compare) {
        Boolean ret = false;
        Date minDate = DateUtil.dateOnlyExt(min);
        Date maxDate = DateUtil.dateOnlyExt(DateUtil.addDays(min, 1));
        if (compare.after(minDate) && compare.before(maxDate)) {
            ret = true;
        }
        return ret;
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return cal.getTime();
    }

    public static Map<String, String> getFLDayMap(String monthRange) {
        return DateUtil.getFLDayMap(monthRange, DEFAULT_DATE_FORMAT);
    }

    public static Map<String, String> getFLDayMap(String monthRange, String pattern) {
        LinkedHashMap<String, String> rs = new LinkedHashMap<String, String>();
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        if (StringUtils.isBlank((String)monthRange)) {
            monthRange = "cm";
        }
        if (!"sm".equals(monthRange)) {
            if ("pm".equals(monthRange)) {
                calendar.add(2, -1);
            }
            calendar.set(5, 1);
            rs.put("firstDay", df.format(calendar.getTime()));
            calendar.set(5, calendar.getActualMaximum(5));
            rs.put("lastDay", df.format(calendar.getTime()));
            return rs;
        }
        int[][] seasons = new int[][]{{2, 4}, {5, 7}, {8, 10}, {11, 1}};
        int cm = calendar.get(2) + 1;
        int[][] nArrayArray = seasons;
        int n = seasons.length;
        int n2 = 0;
        while (n2 < n) {
            int[] im = nArrayArray[n2];
            if (cm >= im[0] && cm <= im[1]) {
                calendar.set(2, im[0] - 1);
                calendar.set(5, 1);
                rs.put("firstDay", df.format(calendar.getTime()));
                calendar.set(2, im[1] - 1);
                calendar.set(5, calendar.getActualMaximum(5));
                rs.put("lastDay", df.format(calendar.getTime()));
                break;
            }
            ++n2;
        }
        return rs;
    }

    public static String getYearString(Date date) {
        return DateUtil.date(date, DEFAULT_YEAR_FORMAT);
    }

    public static int getYearInteger(Date date) {
        return Integer.parseInt(DateUtil.date(date, DEFAULT_YEAR_FORMAT));
    }

    public static String getMonthString(Date date) {
        return DateUtil.date(date, DEFAULT_MONTH_FORMAT);
    }

    public static int getMonthInteger(Date date) {
        return Integer.parseInt(DateUtil.date(date, DEFAULT_MONTH_FORMAT));
    }

    public static Date getLastDayOfCurMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getFirstDayOfCurMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.add(5, 0);
        return cal.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static boolean isValidDate(String ds) {
        if (StringUtils.isBlank((String)ds)) {
            return false;
        }
        return pattern.matcher(ds).matches();
    }

    public static boolean isValidDate(Date d) {
        if (d == null) {
            return false;
        }
        return pattern.matcher(DateUtil.date(d, DEFAULT_DATE_FORMAT)).matches();
    }
}

