/*
 * Decompiled with CFR 0.152.
 */
package com.kintiger.platform.wfe.service.impl;

import com.kintiger.platform.allUser.pojo.AllUsers;
import com.kintiger.platform.framework.util.JsonUtil;
import com.kintiger.platform.wfe.pojo.Page;
import com.kintiger.platform.wfe.pojo.ProcessEventDetail;
import com.kintiger.platform.wfe.pojo.ProcessEventTotal;
import com.kintiger.platform.wfe.pojo.UserUtil;
import com.kintiger.platform.wfe.service.IWfeService;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WfeServiceImpl
implements IWfeService {
    private static final Log logger = LogFactory.getLog(WfeServiceImpl.class);
    private Client client;

    @Override
    public String startWorkflow(Object[] res) {
        String processInstanceId = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("startWorkflow", res);
            processInstanceId = results[0].toString();
        }
        catch (Exception e) {
            return "";
        }
        return processInstanceId;
    }

    @Override
    public Page<ProcessEventTotal> findTodoTasks(Object[] res) {
        Page page = new Page();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("findTodoTasks", res);
            HashMap<String, Class<ProcessEventTotal>> classMap = new HashMap<String, Class<ProcessEventTotal>>();
            classMap.put("result", ProcessEventTotal.class);
            page = (Page)JsonUtil.getDTO(results[0].toString(), Page.class, classMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return page;
    }

    @Override
    public Page<ProcessEventTotal> findTasksByUser(Object[] res) {
        Page page = new Page();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("findTasksByUser", res);
            HashMap<String, Class<ProcessEventTotal>> classMap = new HashMap<String, Class<ProcessEventTotal>>();
            classMap.put("result", ProcessEventTotal.class);
            page = (Page)JsonUtil.getDTO(results[0].toString(), Page.class, classMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return page;
    }

    @Override
    public Page<ProcessEventTotal> findProcessedTasks(Object[] res) {
        Page page = new Page();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("findProcessedTasks", res);
            HashMap<String, Class<ProcessEventTotal>> classMap = new HashMap<String, Class<ProcessEventTotal>>();
            classMap.put("result", ProcessEventTotal.class);
            page = (Page)JsonUtil.getDTO(results[0].toString(), Page.class, classMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return page;
    }

    @Override
    public String startSemiAutomaticWorkflow(Object[] res) {
        String processInstanceId = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("startSemiautomaticWorkflow", res);
            processInstanceId = results[0].toString();
        }
        catch (MalformedURLException results) {
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return processInstanceId;
    }

    @Override
    public List<ProcessEventDetail> findTasksByUserProcessInstanceId(String processInstanceId) {
        List<ProcessEventDetail> list = new ArrayList<ProcessEventDetail>();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("findTasksByUserProcessInstanceId", new Object[]{processInstanceId});
            list = JsonUtil.getDTOList(results[0].toString(), ProcessEventDetail.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return list;
    }

    @Override
    public String complete(Object[] res) {
        String result = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("complete", res);
            result = results[0].toString();
        }
        catch (MalformedURLException results) {
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return result;
    }

    @Override
    public String startAnyProcessWorkflow(Object[] res) {
        String processInstanceId = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("startAnyWorkflow", res);
            processInstanceId = results[0].toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return processInstanceId;
    }

    @Override
    public String cancelEvent(String eventId) {
        String result = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("cancelEvent", new Object[]{eventId});
            result = results[0].toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return result;
    }

    public ProcessEventTotal findEventTotalById(String eventId) {
        ProcessEventTotal eventTotal = new ProcessEventTotal();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("findEventTotalById", new Object[]{eventId});
            eventTotal = (ProcessEventTotal)JsonUtil.getDTO(results[0].toString(), ProcessEventTotal.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return eventTotal;
    }

    @Override
    public UserUtil startWorkflowFix(Object[] res) {
        UserUtil userUtil = new UserUtil();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("startWorkflowFix", res);
            HashMap<String, Class<AllUsers>> classMap = new HashMap<String, Class<AllUsers>>();
            classMap.put("result", AllUsers.class);
            userUtil = (UserUtil)JsonUtil.getDTO(results[0].toString(), UserUtil.class, classMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return userUtil;
    }

    @Override
    public String processWorkflowFix(Object[] res) {
        String processInstanceId = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("processWorkflowFix", res);
            processInstanceId = results[0].toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return processInstanceId;
    }

    @Override
    public UserUtil startProcessNexUser(Object[] res) {
        UserUtil userUtil = new UserUtil();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("completeProcess", res);
            HashMap<String, Class<AllUsers>> classMap = new HashMap<String, Class<AllUsers>>();
            classMap.put("result", AllUsers.class);
            userUtil = (UserUtil)JsonUtil.getDTO(results[0].toString(), UserUtil.class, classMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return userUtil;
    }

    @Override
    public String processCommit(Object[] res) {
        String result = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("commitProcess", res);
            result = results[0].toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String deployProcessDefinition(String xmlString, String processDefinitionName) {
        String result = "";
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] res = new Object[]{xmlString, processDefinitionName};
            Object[] results = this.client.invoke("deployProcessDefinition", res);
            result = (String)results[0];
            return result;
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            return result;
        }
    }

    @Override
    public UserUtil getProcessRole(Object[] res) {
        UserUtil userUtil = new UserUtil();
        try {
            if (this.client == null) {
                this.init();
            }
            Object[] results = this.client.invoke("getAllUserTask", res);
            HashMap<String, Class<AllUsers>> classMap = new HashMap<String, Class<AllUsers>>();
            classMap.put("result", AllUsers.class);
            userUtil = (UserUtil)JsonUtil.getDTO(results[0].toString(), UserUtil.class, classMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return userUtil;
    }

    protected void init() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("spring/spring-wfe.xml");
        this.client = (Client)ctx.getBean("client");
    }

    protected void destroy() {
        this.client.destroy();
        this.client = null;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

