/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.collections;

import com.crystaldecisions.celib.collections.ISimpleCache;
import java.util.Map;

public class SimpleCache
implements ISimpleCache {
    private Map m_map = null;
    private final long m_timeout;

    public SimpleCache(Map map, long timeout) {
        this.m_map = map;
        this.m_timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, Object[] args, ISimpleCache.IRefreshHelper helper) throws ISimpleCache.RefreshException {
        Object content;
        CacheEntry entry;
        Map map = this.m_map;
        synchronized (map) {
            entry = (CacheEntry)this.m_map.get(key);
            if (entry == null) {
                entry = new CacheEntry(null);
                this.m_map.put(key, entry);
            }
        }
        CacheEntry cacheEntry = entry;
        synchronized (cacheEntry) {
            if (!entry.expired(this.m_timeout) && (content = entry.getContent()) != null && !helper.isCacheOutdated(content, args)) {
                return content;
            }
        }
        if (helper != null) {
            try {
                content = helper.refresh(key, args);
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ISimpleCache.RefreshException(null, e);
            }
            cacheEntry = entry;
            synchronized (cacheEntry) {
                Object content1;
                if (!entry.expired(this.m_timeout) && (content1 = entry.getContent()) != null) {
                    return content1;
                }
                entry.setContent(content);
                return content;
            }
        }
        return null;
    }

    private static class CacheEntry {
        private long m_lastVisited;
        private Object m_content;

        private void touch() {
            this.m_lastVisited = System.currentTimeMillis();
        }

        private CacheEntry(Object content) {
            this.m_content = content;
            this.touch();
        }

        private boolean expired(long timeout) {
            if (timeout > 0L) {
                return System.currentTimeMillis() - this.m_lastVisited > timeout;
            }
            return false;
        }

        private Object getContent() {
            return this.m_content;
        }

        private void setContent(Object content) {
            this.m_content = content;
            this.touch();
        }
    }
}

