/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.collections;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import java.util.Properties;

public class SystemPrioritizedProperties
extends Properties {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.collections.SystemPrioritizedProperties");

    public String getProperty(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        return super.getProperty(key);
    }

    public String getResolvedValue(String key) {
        return this.resolveVariable(this.getProperty(key));
    }

    public String getResolvedValue(String key, String defaultVal) {
        return this.resolveVariable(this.getProperty(key, defaultVal));
    }

    private String resolveVariable(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(rawValue.length());
        int enclosing = -1;
        int pos = rawValue.indexOf("${");
        while (pos != -1) {
            buffer.append(rawValue.substring(enclosing + 1, pos));
            enclosing = rawValue.indexOf(125, pos + 2);
            if (enclosing != -1) {
                String varName = rawValue.substring(pos + 2, enclosing);
                String propValue = this.getProperty(varName);
                if (propValue != null) {
                    buffer.append(this.resolveVariable(propValue));
                } else {
                    propValue = System.getProperty(varName);
                    if (propValue != null) {
                        buffer.append(propValue);
                    } else {
                        LOG.warn((Object)("(resolveVariable:452): variable " + varName + " not found"));
                        buffer.append("${" + varName + "}");
                    }
                }
                pos = rawValue.indexOf("${", enclosing + 1);
                continue;
            }
            enclosing = pos - 1;
            pos = -1;
        }
        buffer.append(rawValue.substring(enclosing + 1));
        return buffer.toString();
    }
}

