/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.commandline;

import java.util.HashMap;
import java.util.Map;

public class ArgsReader {
    private String[] m_toBeParsed;
    private Map m_args;
    public static final char ARG_PREFIX = '-';

    public ArgsReader(String[] toBeParsed) {
        this.m_toBeParsed = toBeParsed;
        this.parse();
    }

    public Map getArgs() {
        return this.m_args;
    }

    public String getArg(String argName) {
        return (String)this.m_args.get(argName);
    }

    public String getArg(String argName, String defValue) {
        String strVal = this.getArg(argName);
        if (strVal != null) {
            return strVal;
        }
        return defValue;
    }

    public int getArg(String argName, int defValue) {
        String valueStr = (String)this.m_args.get(argName);
        if (valueStr != null) {
            return Integer.parseInt(valueStr);
        }
        return defValue;
    }

    public boolean getArg(String argName, boolean defaultValue) {
        String valueStr = (String)this.m_args.get(argName);
        if (valueStr != null) {
            return Boolean.valueOf(valueStr);
        }
        if (this.m_args.keySet().contains(argName)) {
            return true;
        }
        return defaultValue;
    }

    private void parse() {
        this.m_args = new HashMap();
        boolean lookingForKey = true;
        String lastKey = null;
        for (int i = 0; i < this.m_toBeParsed.length; ++i) {
            String arg = this.m_toBeParsed[i];
            if (arg.length() > 0 && arg.charAt(0) == '-') {
                if (lookingForKey) {
                    lastKey = arg.substring(1);
                    lookingForKey = false;
                    continue;
                }
                if (lastKey != null) {
                    this.m_args.put(lastKey, null);
                    lastKey = arg.substring(1);
                    lookingForKey = false;
                    continue;
                }
                throw new IllegalArgumentException(arg);
            }
            if (lookingForKey) {
                throw new IllegalArgumentException(arg);
            }
            this.m_args.put(lastKey, arg);
            lastKey = null;
            lookingForKey = true;
        }
        if (lastKey != null && !lookingForKey) {
            this.m_args.put(lastKey, null);
        }
    }
}

