/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.conversion;

public class IntegerConversion {
    private static final int s_multmin_positive = -214748364;
    private static final int s_multmin_negative = -214748364;
    public static final Integer ZERO = new Integer(0);
    private static final Integer ONE = new Integer(1);

    public static int parseInt(String s) {
        return IntegerConversion.parseInt(s, 0, s.length());
    }

    public static int parseInt(String s, int offset, int end, int radix) throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int i = offset;
        int max = end;
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(offset) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s.substring(offset, end));
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s.substring(offset, end));
                }
                if (result < multmin) {
                    throw new NumberFormatException(s.substring(offset, end));
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException(s.substring(offset, end));
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException(s.substring(offset, end));
        }
        if (negative) {
            if (i - offset > 1) {
                return result;
            }
            throw new NumberFormatException();
        }
        return -result;
    }

    private static NumberFormatException newFormatEx(char[] ca, int offset, int end) {
        return new NumberFormatException(new String(ca, offset, end));
    }

    public static int parseInt(char[] ca, int offset, int end, int radix) throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int i = offset;
        int max = end;
        if (max > 0) {
            int digit;
            int limit;
            if (ca[offset] == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(ca[i++], radix)) < 0) {
                    throw IntegerConversion.newFormatEx(ca, offset, end);
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(ca[i++], radix)) < 0) {
                    throw IntegerConversion.newFormatEx(ca, offset, end);
                }
                if (result < multmin) {
                    throw IntegerConversion.newFormatEx(ca, offset, end);
                }
                if ((result *= radix) < limit + digit) {
                    throw IntegerConversion.newFormatEx(ca, offset, end);
                }
                result -= digit;
            }
        } else {
            throw IntegerConversion.newFormatEx(ca, offset, end);
        }
        if (negative) {
            if (i - offset > 1) {
                return result;
            }
            throw new NumberFormatException();
        }
        return -result;
    }

    public static int parseInt(char[] s, int offset, int end) {
        return IntegerConversion.parseInt(s, offset, end, 10);
    }

    public static int parseInt(String s, int offset, int end) {
        return IntegerConversion.parseInt(s, offset, end, 10);
    }

    public static boolean comIntToBoolean(int value) {
        return value != 0;
    }

    public static int booleanToCOMInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer parseInteger(char[] s, int offset, int end) {
        int result = 0;
        int i = offset;
        int max = end;
        boolean negative = false;
        if (max > 0) {
            int digit;
            int limit;
            int multlimit;
            if (s[offset] == '-') {
                negative = true;
                ++i;
                multlimit = -214748364;
                limit = Integer.MIN_VALUE;
            } else {
                multlimit = -214748364;
                limit = -2147483647;
            }
            if (i < max) {
                if ((digit = s[i++] - 48) < 0 || digit > 9) {
                    return null;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = s[i++] - 48) < 0 || digit > 9) {
                    return null;
                }
                if (result < multlimit) {
                    return null;
                }
                if ((result *= 10) < limit + digit) {
                    return null;
                }
                result -= digit;
            }
        } else {
            return IntegerConversion.getDefaultInteger(0);
        }
        if (negative) {
            if (i - offset > 1) {
                return new Integer(result);
            }
            return null;
        }
        return IntegerConversion.getDefaultInteger(-result);
    }

    public static Integer parseInteger(String s, int offset, int end) {
        int result = 0;
        int i = offset;
        int max = end;
        boolean negative = false;
        if (max > 0) {
            int digit;
            int limit;
            int multlimit;
            if (s.charAt(offset) == '-') {
                negative = true;
                ++i;
                multlimit = -214748364;
                limit = Integer.MIN_VALUE;
            } else {
                multlimit = -214748364;
                limit = -2147483647;
            }
            if (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    return null;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    return null;
                }
                if (result < multlimit) {
                    return null;
                }
                if ((result *= 10) < limit + digit) {
                    return null;
                }
                result -= digit;
            }
        } else {
            return IntegerConversion.getDefaultInteger(0);
        }
        if (negative) {
            if (i - offset > 1) {
                return new Integer(result);
            }
            return null;
        }
        return IntegerConversion.getDefaultInteger(-result);
    }

    public static Integer parseInteger(String s) {
        return IntegerConversion.parseInteger(s, 0, s.length());
    }

    public static Integer getDefaultInteger(int value) {
        return value == 0 ? ZERO : (value == 1 ? ONE : new Integer(value));
    }
}

