/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.exception;

import com.businessobjects.foundation.exception.CheckedException;
import com.businessobjects.foundation.exception.IException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class CEException
extends Exception
implements IException,
Cloneable {
    private ResourceBundle m_resourceBundle;
    private String[] m_messageParams;
    private String m_resourceID;
    private String m_locID;
    private int m_errorCode;
    private Throwable m_cause;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CheckedException m_checkedException;

    protected CEException(String[] message, Throwable cause, String errorCode) {
        String locID;
        String resourceID = this.getClass().getName();
        resourceID = resourceID.replace('.', '/');
        int delim = resourceID.lastIndexOf(36);
        if (delim != -1) {
            locID = resourceID.substring(delim + 1);
            resourceID = resourceID.substring(0, delim);
        } else {
            delim = resourceID.lastIndexOf(47);
            locID = delim != -1 ? resourceID.substring(delim + 1) : resourceID;
        }
        resourceID = resourceID + "Resources";
        this.m_checkedException = new CheckedException(resourceID, locID, null, (Object[])message, this.getClass().getClassLoader(), cause);
        this.m_messageParams = message;
        this.m_errorCode = Integer.parseInt(errorCode);
    }

    public CEException(String resourceID, String locID, String errorCode, String[] messageParams, Throwable cause) {
        this.m_checkedException = new CheckedException(resourceID, locID, null, (Object[])messageParams, (Object)this, this.getClass().getClassLoader(), cause);
        this.m_messageParams = messageParams;
        this.m_errorCode = Integer.parseInt(errorCode);
    }

    protected CEException(String[] message, Throwable cause) {
        this(message, cause, 0);
    }

    protected CEException(String resourceID, String locID, String[] messageParams, Throwable cause) {
        this(resourceID, locID, messageParams, cause, 0);
    }

    protected CEException(ResourceBundle resourceBundle, String locID, String[] messageParams, Throwable cause) {
        this(resourceBundle, locID, messageParams, cause, 0);
    }

    protected CEException(String[] message, Throwable cause, int errorCode) {
        this(message, cause, String.valueOf(errorCode));
    }

    protected CEException(String resourceID, String locID, String[] messageParams, Throwable cause, int errorCode) {
        this.m_checkedException = new CheckedException(resourceID, locID, null, (Object[])messageParams, this.getClass().getClassLoader(), cause);
        this.m_messageParams = messageParams;
        this.m_errorCode = errorCode;
    }

    protected CEException(ResourceBundle resourceBundle, String locID, String[] messageParams, Throwable cause, int errorCode) {
        this.m_messageParams = messageParams;
        this.m_resourceID = null;
        this.m_locID = locID;
        this.m_cause = cause;
        this.m_errorCode = errorCode;
        this.m_resourceBundle = resourceBundle;
    }

    public Throwable getCause() {
        if (this.m_checkedException != null) {
            return this.m_checkedException.getCause();
        }
        return this.m_cause;
    }

    public String getDetailMessage() {
        return this.getDetailMessage(CheckedException.getMessageLocale());
    }

    protected Object[] getCheckedExceptionMessageParams() {
        if (this.m_checkedException != null) {
            return this.m_checkedException.getParams();
        }
        return null;
    }

    public String getDetailMessage(Locale locale) {
        if (this.m_checkedException != null) {
            return this.m_checkedException.getDetailMessage(locale);
        }
        String message = this.getMessage(locale);
        ResourceBundle local = ResourceBundle.getBundle("com/crystaldecisions/celib/exception/AbstractExceptionResources", locale);
        if (this.m_cause != null) {
            message = message + LINE_SEPARATOR;
            if (this.m_cause instanceof CEException) {
                String causeFmt = local.getString("cause2");
                String causeMsg = ((CEException)this.m_cause).getDetail();
                message = message + MessageFormat.format(causeFmt, this.m_cause.toString(), causeMsg);
            } else {
                String causeFmt = local.getString("cause1");
                message = message + MessageFormat.format(causeFmt, this.m_cause.toString());
            }
        }
        return message;
    }

    public String getErrorCodeString() {
        if (this.m_checkedException != null) {
            return this.m_checkedException.getErrorCodeString();
        }
        return "";
    }

    public String serialize() {
        if (this.m_checkedException != null) {
            return this.m_checkedException.serialize();
        }
        return "";
    }

    public String getMessage(Locale locale) {
        Format[] formats;
        ResourceBundle bundle;
        if (this.m_checkedException != null) {
            return this.m_checkedException.getMessage(locale);
        }
        if (locale == null) {
            locale = CheckedException.getMessageLocale();
        }
        if ((bundle = this.m_resourceBundle) == null) {
            bundle = ResourceBundle.getBundle(this.m_resourceID, locale);
        }
        String message = bundle.getString(this.m_locID);
        if (this.m_messageParams != null && (formats = new MessageFormat(message).getFormats()) != null && formats.length > 0) {
            message = MessageFormat.format(message, this.m_messageParams);
        }
        return message;
    }

    public String getMessage() {
        return this.getMessage(CheckedException.getMessageLocale());
    }

    public String getDetail() {
        return this.getDetailMessage();
    }

    public String toString() {
        if (this.m_checkedException != null) {
            Throwable cause = this.m_checkedException.getCause();
            if (cause != null) {
                return super.toString() + LINE_SEPARATOR + "cause:" + cause.toString() + LINE_SEPARATOR + "detail:" + this.getDetail();
            }
            return super.toString();
        }
        if (this.m_cause != null) {
            return super.toString() + LINE_SEPARATOR + "cause:" + this.m_cause.toString() + LINE_SEPARATOR + "detail:" + this.getDetail();
        }
        return super.toString();
    }

    public String[] getMessageParams() {
        return this.m_messageParams;
    }

    public int getExceptionCode() {
        return this.m_errorCode;
    }

    protected static int getExceptionCode(Throwable cause, int defaultCode) {
        return cause != null && cause instanceof CEException ? ((CEException)cause).getExceptionCode() : defaultCode;
    }
}

