/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.exception;

import com.businessobjects.foundation.exception.IException;
import com.businessobjects.foundation.exception.UncheckedException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class CERuntimeException
extends RuntimeException
implements IException,
Cloneable {
    private ResourceBundle m_resourceBundle;
    private String[] m_messageParams;
    private String m_resourceID;
    private String m_locID;
    private int m_errorCode;
    private Throwable m_cause;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private UncheckedException m_uncheckedException;

    protected CERuntimeException(String[] message, Throwable cause, String errorCode) {
        String locID;
        String resourceID = this.getClass().getName();
        resourceID = resourceID.replace('.', '/');
        int delim = resourceID.lastIndexOf(36);
        if (delim != -1) {
            locID = resourceID.substring(delim + 1);
            resourceID = resourceID.substring(0, delim);
        } else {
            delim = resourceID.lastIndexOf(47);
            locID = delim != -1 ? resourceID.substring(delim + 1) : resourceID;
        }
        resourceID = resourceID + "Resources";
        this.m_uncheckedException = new UncheckedException(resourceID, locID, null, (Object[])message, this.getClass().getClassLoader(), cause);
        this.m_messageParams = message;
        this.m_errorCode = Integer.parseInt(errorCode);
    }

    public CERuntimeException(String resourceID, String locID, String errorCode, String[] messageParams, Throwable cause) {
        this.m_uncheckedException = new UncheckedException(resourceID, locID, null, (Object[])messageParams, this.getClass().getClassLoader(), cause);
        this.m_messageParams = messageParams;
        this.m_errorCode = Integer.parseInt(errorCode);
    }

    protected CERuntimeException(String[] message, Throwable cause) {
        this(message, cause, 0);
    }

    protected CERuntimeException(String resourceID, String locID, String[] messageParams, Throwable cause) {
        this(resourceID, locID, messageParams, cause, 0);
    }

    protected CERuntimeException(ResourceBundle resourceBundle, String locID, String[] messageParams, Throwable cause) {
        this(resourceBundle, locID, messageParams, cause, 0);
    }

    protected CERuntimeException(String[] message, Throwable cause, int errorCode) {
        this(message, cause, String.valueOf(errorCode));
    }

    protected CERuntimeException(String resourceID, String locID, String[] messageParams, Throwable cause, int errorCode) {
        this.m_uncheckedException = new UncheckedException(resourceID, locID, null, (Object[])messageParams, this.getClass().getClassLoader(), cause);
        this.m_messageParams = messageParams;
        this.m_errorCode = errorCode;
    }

    protected CERuntimeException(ResourceBundle resourceBundle, String locID, String[] messageParams, Throwable cause, int errorCode) {
        this.m_messageParams = messageParams;
        this.m_resourceID = null;
        this.m_locID = locID;
        this.m_cause = cause;
        this.m_errorCode = errorCode;
        this.m_resourceBundle = resourceBundle;
    }

    public Throwable getCause() {
        if (this.m_uncheckedException != null) {
            return this.m_uncheckedException.getCause();
        }
        return this.m_cause;
    }

    public String getDetailMessage() {
        return this.getDetailMessage(UncheckedException.getMessageLocale());
    }

    public String getDetailMessage(Locale locale) {
        if (this.m_uncheckedException != null) {
            Object[] params = this.m_uncheckedException.getParams();
            if (params != null && params.length > 0) {
                params[0] = this.m_messageParams[0];
            }
            return this.m_uncheckedException.getDetailMessage(locale);
        }
        String message = this.getMessage(locale);
        ResourceBundle local = ResourceBundle.getBundle("com/crystaldecisions/celib/exception/AbstractExceptionResources", locale);
        if (this.m_cause != null) {
            message = message + LINE_SEPARATOR;
            if (this.m_cause instanceof CERuntimeException) {
                String causeFmt = local.getString("cause2");
                String causeMsg = ((CERuntimeException)this.m_cause).getDetailMessage();
                message = message + MessageFormat.format(causeFmt, this.m_cause.toString(), causeMsg);
            } else {
                String causeFmt = local.getString("cause1");
                message = message + MessageFormat.format(causeFmt, this.m_cause.toString());
            }
        }
        return message;
    }

    public String getErrorCodeString() {
        if (this.m_uncheckedException != null) {
            return this.m_uncheckedException.getErrorCodeString();
        }
        return "";
    }

    public String serialize() {
        if (this.m_uncheckedException != null) {
            return this.m_uncheckedException.serialize();
        }
        return "";
    }

    public String getMessage(Locale locale) {
        ResourceBundle bundle;
        if (this.m_uncheckedException != null) {
            Object[] params = this.m_uncheckedException.getParams();
            if (params != null && params.length > 0) {
                params[0] = this.m_messageParams[0];
            }
            return this.m_uncheckedException.getMessage(locale);
        }
        if (locale == null) {
            locale = UncheckedException.getMessageLocale();
        }
        if ((bundle = this.m_resourceBundle) == null) {
            bundle = ResourceBundle.getBundle(this.m_resourceID, locale);
        }
        String message = bundle.getString(this.m_locID);
        if (this.m_messageParams != null && message.indexOf("{0}") != -1) {
            message = MessageFormat.format(message, this.m_messageParams);
        }
        return message;
    }

    public String getMessage() {
        return this.getMessage(UncheckedException.getMessageLocale());
    }

    public String toString() {
        if (this.m_uncheckedException != null) {
            Throwable cause = this.m_uncheckedException.getCause();
            if (cause != null) {
                return super.toString() + LINE_SEPARATOR + "cause:" + cause.toString() + LINE_SEPARATOR + "detail:" + this.getDetailMessage();
            }
            return super.toString();
        }
        if (this.m_cause != null) {
            return super.toString() + LINE_SEPARATOR + "cause:" + this.m_cause.toString() + LINE_SEPARATOR + "detail:" + this.getDetailMessage();
        }
        return super.toString();
    }

    protected String[] getMessageParams() {
        return this.m_messageParams;
    }

    public int getExceptionCode() {
        return this.m_errorCode;
    }

    protected static int getExceptionCode(Throwable cause, int defaultCode) {
        return cause != null && cause instanceof CERuntimeException ? ((CERuntimeException)cause).getExceptionCode() : defaultCode;
    }
}

