/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.exception;

import java.io.PrintStream;
import java.util.Date;

public class Debugger {
    private static int s_order;
    private static final boolean ON;
    private static final boolean s_dumpStackTrace;
    private static final boolean s_printThreadInfo;
    private static final boolean s_printTimeStamp;
    private static PrintStream s_out;
    private static final String CR;
    private static final Object s_lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(Object obj) {
        if (ON) {
            Object object = s_lock;
            synchronized (object) {
                s_out.print("[" + ++s_order + "]");
                if (s_printTimeStamp) {
                    s_out.println(new Date());
                }
                if (s_printThreadInfo) {
                    s_out.println(Thread.currentThread());
                }
                if (s_dumpStackTrace) {
                    new Exception("stack trace").printStackTrace(s_out);
                }
                s_out.print("Message:");
                s_out.println(obj);
                s_out.println();
            }
        }
    }

    public static String arrayHelper(Object[] objs) {
        StringBuffer buffer = new StringBuffer();
        if (ON) {
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    buffer.append(i + "=" + objs[i] + CR);
                }
            } else {
                buffer.append("null" + CR);
            }
        }
        return buffer.toString();
    }

    static {
        ON = Boolean.getBoolean("crystal.enterprise.debug.on");
        s_dumpStackTrace = Boolean.getBoolean("crystal.enterprise.debug.stack_trace");
        s_printThreadInfo = Boolean.getBoolean("crystal.enterprise.debug.thread_info");
        s_printTimeStamp = Boolean.getBoolean("crystal.enterprise.debug.time_stamp");
        CR = System.getProperty("line.separator");
        s_lock = new Object();
        String customPrintStream = System.getProperty("crystal.enterprise.debug.output_class");
        if (customPrintStream != null) {
            try {
                Class<?> clazz = Class.forName(customPrintStream);
                s_out = (PrintStream)clazz.newInstance();
            }
            catch (Exception e) {
                s_out = System.out;
            }
        } else {
            s_out = System.out;
        }
    }
}

