/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.io;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.SILibException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PersistentConfiguration
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String configFilesHome;
    private static final String PERSIST_CONFIGURATION_DIRECTORY = "com.businessobjects.enterprise.persistdirectory";
    private static final ILogger LOG;
    private final String fileNameFullPath;

    public PersistentConfiguration(String fileName) {
        this.fileNameFullPath = configFilesHome + File.separatorChar + fileName + ".properties";
    }

    public void refresh() throws SILibException {
        try {
            try {
                FileInputStream inFile = new FileInputStream(this.fileNameFullPath);
                this.load(inFile);
                inFile.close();
            }
            catch (FileNotFoundException e) {
                return;
            }
        }
        catch (IOException e) {
            LOG.error((Object)("refresh() - Error while reading configuration file " + this.fileNameFullPath), (Throwable)e);
            throw new SILibException(new String[]{"IO Error while reading configuration file " + this.fileNameFullPath}, e);
        }
    }

    public void flush() throws SILibException {
        File prefsDirectory = new File(configFilesHome);
        prefsDirectory.mkdir();
        try {
            FileOutputStream outFile = new FileOutputStream(this.fileNameFullPath);
            this.store(outFile, null);
            outFile.close();
            return;
        }
        catch (Exception e) {
            LOG.error((Object)("refresh() - Error while writing configuration file " + this.fileNameFullPath), (Throwable)e);
            throw new SILibException(new String[]{"Unable to write configuration file " + this.fileNameFullPath}, e);
        }
    }

    static {
        LOG = LoggerManager.getLogger((Class)PersistentConfiguration.class);
        String overrideDirectory = System.getProperty(PERSIST_CONFIGURATION_DIRECTORY);
        configFilesHome = overrideDirectory != null ? overrideDirectory : System.getProperty("user.home") + File.separatorChar + ".businessobjects";
    }
}

