/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class URLEncodingWriter
extends FilterWriter {
    static final boolean[] toEncode = new boolean[256];
    static final char[][] encoded = new char[256][];
    static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private char[] unicodeEncoding = null;

    public URLEncodingWriter(Writer to) {
        super(to);
    }

    public void write(int c) throws IOException {
        if (c <= 255) {
            if (!toEncode[c]) {
                this.out.write(c);
            } else {
                this.out.write(encoded[c], 0, encoded[c].length);
            }
        } else {
            if (this.unicodeEncoding == null) {
                this.unicodeEncoding = new char[]{'%', 'u', '0', '0', '0', '0'};
            }
            this.unicodeEncoding[2] = hexChars[(c & 0xF000) >> 12];
            this.unicodeEncoding[3] = hexChars[(c & 0xF00) >> 8];
            this.unicodeEncoding[4] = hexChars[(c & 0xF0) >> 4];
            this.unicodeEncoding[5] = hexChars[(c & 0xF) >> 0];
            this.out.write(this.unicodeEncoding, 0, this.unicodeEncoding.length);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(cbuf[i]);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(str.charAt(i));
        }
    }

    static {
        int c = 0;
        while (c < 32) {
            URLEncodingWriter.toEncode[c++] = true;
        }
        URLEncodingWriter.toEncode[125] = true;
        URLEncodingWriter.toEncode[123] = true;
        URLEncodingWriter.toEncode[44] = true;
        URLEncodingWriter.toEncode[61] = true;
        URLEncodingWriter.toEncode[43] = true;
        URLEncodingWriter.toEncode[38] = true;
        URLEncodingWriter.toEncode[37] = true;
        URLEncodingWriter.toEncode[36] = true;
        URLEncodingWriter.toEncode[32] = true;
        c = 127;
        while (c < 256) {
            URLEncodingWriter.toEncode[c++] = true;
        }
        for (int i = 0; i < 256; ++i) {
            if (!toEncode[i]) continue;
            URLEncodingWriter.encoded[i] = new char[3];
            URLEncodingWriter.encoded[i][0] = 37;
            URLEncodingWriter.encoded[i][1] = hexChars[(i & 0xF0) >> 4];
            URLEncodingWriter.encoded[i][2] = hexChars[i & 0xF];
        }
        URLEncodingWriter.encoded[32] = new char[]{'+'};
    }
}

