/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.celib.collections.CaseInsensHashMap;
import com.crystaldecisions.celib.collections.FastSimpleTable;
import com.crystaldecisions.celib.conversion.IntegerConversion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public class IDHelper {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.properties.IDHelper");
    private static final int REGULAR_ID_BASE = 0x1000000;
    private static final int UNFIXED_ID_BASE = 0x10000000;
    private static final int ARRAY_ID_BASE = 0x2000000;
    private static final int ARRAY_ID_INTERVAL = 0x1000000;
    private static final int ARRAY_ID_INDEXMASK = 0xFFFFFF;
    private static final int ARRAY_ID_BASEMASK = -16777216;
    private static final FastSimpleTable s_mapIDByName = new FastSimpleTable(new CaseInsensHashMap(800));
    private static final FastSimpleTable s_mapNameByID = new FastSimpleTable(new HashMap(800));
    private static int s_lastID = 0x10000000;
    private static int s_lastIndexedID = 0x2000000;
    private static final Object s_lock = new Object();
    private static final String UNKNOWN_ID_MARKER = "#";

    public static String idToName(Integer id) {
        if (0 <= id && id <= 0x1000000) {
            return id.toString();
        }
        if (IDHelper.isArray(id)) {
            Integer base = new Integer((int)(id & 0xFF000000));
            String baseName = (String)s_mapNameByID.get(base);
            return baseName.substring(0, baseName.length() - 1) + (id & 0xFFFFFF);
        }
        String name = (String)s_mapNameByID.get(id);
        if (name != null) {
            return name;
        }
        return UNKNOWN_ID_MARKER + IDHelper.toWiredRegular(id) + UNKNOWN_ID_MARKER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer nameToID(String name) {
        Integer id = null;
        if (IDHelper.isEnterpriseDigit(name.charAt(0))) {
            id = IntegerConversion.parseInteger(name);
        }
        if (id == null) {
            if (IDHelper.isEnterpriseDigit(name.charAt(name.length() - 1))) {
                id = IDHelper.indexedNameToID(name);
            }
            if (id == null && (id = (Integer)s_mapIDByName.get(name)) == null) {
                if (IDHelper.isUnknown(name)) {
                    String idStr = name.substring(UNKNOWN_ID_MARKER.length(), name.length() - UNKNOWN_ID_MARKER.length());
                    int wired = Integer.parseInt(idStr);
                    id = new Integer(IDHelper.toRegular(wired));
                } else {
                    Object idStr = s_lock;
                    synchronized (idStr) {
                        id = new Integer(++s_lastID);
                    }
                    String notShared = new String(name);
                    id = (Integer)s_mapIDByName.putUnlessExists(notShared, id);
                    s_mapNameByID.putUnlessExists(id, notShared);
                }
            }
        }
        return id;
    }

    private static Integer indexedNameToID(String name) {
        if (IDHelper.isEnterpriseDigit(name.charAt(name.length() - 1))) {
            char ch;
            int index = name.charAt(name.length() - 1) - 48;
            int radix = 10;
            int i = name.length() - 2;
            while (IDHelper.isEnterpriseDigit(ch = name.charAt(i--)) && i > 0) {
                index += radix * (ch - 48);
                radix = (radix << 3) + (radix << 1);
            }
            String base = (name = name.substring(0, i + 2)) + '0';
            Integer id = (Integer)s_mapIDByName.get(base);
            if (id != null && IDHelper.isArray(id)) {
                id = index == 0 ? id : new Integer(id + index);
                return id;
            }
            return null;
        }
        throw new IllegalArgumentException("This is not an indexed property name.  Call nameToID instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer defineIndexedBase(String base) {
        Integer id = (Integer)s_mapIDByName.get(base);
        if (id == null) {
            Object object = s_lock;
            synchronized (object) {
                if (s_lastIndexedID >= 0x10000000) {
                    throw new IllegalArgumentException("No new indexed properties should be defined.  Use the default indexed properties 1, 2, 3, ...");
                }
                id = new Integer(s_lastIndexedID);
                s_lastIndexedID += 0x1000000;
            }
            id = (Integer)s_mapIDByName.putUnlessExists(base, id);
            s_mapNameByID.putUnlessExists(id, base);
        }
        return id;
    }

    public static Integer define(String name, int value) {
        if (value < 0 || value > 0xF000000) {
            throw new IllegalArgumentException();
        }
        Integer id = (Integer)s_mapIDByName.putUnlessExists(name, new Integer(value + 0x1000000));
        s_mapNameByID.putUnlessExists(id, name);
        return id;
    }

    public static Integer define(String name) {
        return IDHelper.nameToID(name);
    }

    public static Integer upperLimit(Integer id) {
        return new Integer(id + 0x1000000 - 1);
    }

    public static Integer object2Integer(Object id) {
        if (id instanceof Integer) {
            return (Integer)id;
        }
        if (id instanceof String) {
            return IDHelper.nameToID((String)id);
        }
        if (id instanceof Locale) {
            return IDHelper.nameToID(id.toString());
        }
        throw new IllegalArgumentException("property id must be either Integer or String");
    }

    public static String toQueryString(Integer[] propIDs) {
        StringBuffer propList = new StringBuffer();
        if (propIDs != null && propIDs.length > 0) {
            for (int i = 0; i < propIDs.length; ++i) {
                Integer propID = propIDs[i];
                if (i == 0) {
                    propList.append(IDHelper.idToName(propID));
                    continue;
                }
                propList.append(',' + IDHelper.idToName(propID));
            }
        } else {
            propList.append('*');
        }
        return propList.toString();
    }

    public static boolean isEnterpriseDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isRegular(int id) {
        return id >= 0x1000000 && id < 0x2000000;
    }

    public static boolean isArray(int id) {
        return id >= 0x2000000 && id < 0x10000000;
    }

    public static boolean isIndex(int id) {
        return id < 0x1000000;
    }

    public static boolean isUnknown(String name) {
        return name.startsWith(UNKNOWN_ID_MARKER) && name.endsWith(UNKNOWN_ID_MARKER);
    }

    public static int toRegular(int wired) {
        return wired + 0x1000000;
    }

    public static int toIndex(int wired) {
        return wired;
    }

    public static int toArray(int base, int index) {
        return base << 24 | index;
    }

    public static int toWiredRegular(int id) {
        return id - 0x1000000;
    }

    public static int toWiredIndex(int id) {
        return id;
    }

    public static int[] toWiredArray(int id) {
        int[] indexes = new int[]{id >> 24, id & 0xFFFFFF};
        return indexes;
    }

    protected static void preload() {
        s_mapIDByName.preload();
        s_mapNameByID.preload();
    }

    private static void loadPredefinedProperties(String resourceName) {
        try {
            InputStream stream = ClassLoaderHelper.getResourceAsStream(resourceName);
            Properties properties = new Properties();
            properties.load(stream);
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                String propValue = properties.getProperty(propName);
                if (propValue != null && propValue.trim().length() != 0) {
                    try {
                        IDHelper.define(propName, Integer.parseInt(propValue));
                    }
                    catch (NumberFormatException e) {
                        LOG.error((Object)("(loadPredefinedProperties:342): fileName:" + resourceName + ",key=" + propName + ",value=" + propValue), (Throwable)e);
                    }
                    continue;
                }
                IDHelper.define(propName);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("(loadPredefinedProperties:353): can't load property file:" + resourceName), (Throwable)e);
        }
        IDHelper.defineIndexedBase("SI_FILE0");
        IDHelper.defineIndexedBase("SI_TEMPLATE_DATE0");
        IDHelper.defineIndexedBase("SI_TEMPLATE_DAY0");
        IDHelper.defineIndexedBase("SI_FOLDER_NAME0");
        IDHelper.defineIndexedBase("SI_FOLDER_ID0");
        IDHelper.defineIndexedBase("SI_FOLDER_OBTYPE0");
        IDHelper.defineIndexedBase("SI_LOGON0");
        IDHelper.defineIndexedBase("SI_PROMPT0");
        IDHelper.defineIndexedBase("SI_VALUE0");
        IDHelper.defineIndexedBase("SI_ALERT0");
        IDHelper.defineIndexedBase("SI_GROUP_MEMBER0");
        IDHelper.defineIndexedBase("SI_SUBGROUP0");
        IDHelper.defineIndexedBase("SI_SUBST_STRING0");
    }

    static {
        IDHelper.loadPredefinedProperties("com/crystaldecisions/celib/properties/WirePropIDs.properties");
        IDHelper.preload();
    }
}

