/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.properties.FlagHelper;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IStreamBagPacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;

public class ObURLPacker
implements IStreamBagPacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.properties.ObURLPacker");
    private char m_delimiter;
    public static final Integer CLASS_NAME = IDHelper.define("SI_ADMIN_MOCK_PROPERTY_CLASS_NAME");

    public ObURLPacker() {
        this.m_delimiter = (char)38;
    }

    public ObURLPacker(char delimiter) {
        this.m_delimiter = delimiter;
    }

    public IBagPacker getNestedPacker() {
        return this;
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw);
        return sw.toString();
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w) {
        try {
            Property nameProp = properties.getItem(CLASS_NAME);
            int processedCount = 0;
            int size = properties.size() + properties.hiddenValues().size();
            if (nameProp != null) {
                w.write((String)nameProp.getValue());
                if (size > 1) {
                    w.write(63);
                }
                ++processedCount;
            }
            Iterator iter = properties.allIterator();
            while (iter.hasNext()) {
                boolean writeDelimitor;
                Property property = (Property)iter.next();
                if (FlagHelper.isPropertyExcluded(includeMask, excludeMask, property.getFlags())) continue;
                boolean bl = writeDelimitor = processedCount < size - 1;
                if (property.getID().equals(CLASS_NAME)) continue;
                w.write(IDHelper.idToName(property.getID()));
                w.write(61);
                if (property.isContainer()) {
                    int nestedExcludeMask;
                    PropertyBag nested = property.getPropertyBag();
                    IBagPacker packer = this.getNestedPacker();
                    int nestedIncludeMask = recursive ? includeMask : 0;
                    int n = nestedExcludeMask = recursive ? excludeMask : 0;
                    if (packer instanceof IStreamBagPacker) {
                        ((IStreamBagPacker)packer).packToStream(nested, nestedIncludeMask, nestedExcludeMask, recursive, w);
                    } else {
                        w.write(packer.packToChar(nested, nestedIncludeMask, nestedExcludeMask, recursive));
                    }
                } else {
                    Object value = property.getValue();
                    if (value != null) {
                        if (value instanceof Integer) {
                            w.write(value.toString());
                        } else if (value instanceof Long) {
                            w.write(value.toString());
                        } else if (value instanceof Boolean) {
                            w.write((Boolean)value != false ? 49 : 48);
                        } else if (value instanceof Double) {
                            w.write(value.toString());
                        } else if (value instanceof String) {
                            w.write((String)value);
                        } else if (value instanceof Date) {
                            double variantDate = DateConversion.convertToVariantDate((Date)value, null);
                            w.write(Double.toString(variantDate));
                        }
                    }
                }
                if (writeDelimitor) {
                    w.write(this.m_delimiter);
                }
                ++processedCount;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"packToStream(): shouldn't happen", (Throwable)e);
        }
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w, int clearMask, int setMask) {
        this.packToStream(properties, includeMask, excludeMask, recursive, w);
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        return this.pack(properties, includeMask, excludeMask, recursive);
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw);
        return sw.toCharArray();
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        return this.packToChar(properties, includeMask, excludeMask, recursive);
    }
}

