/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class PropertyArrayHelper
extends AbstractList
implements List {
    private final PropertyBag m_bag;
    private final Integer m_countID;
    private final int m_baseID;

    public PropertyArrayHelper(PropertyBag bag, Integer countID, Integer baseID) {
        this.m_bag = bag;
        this.m_countID = countID;
        this.m_baseID = baseID + 1;
    }

    public PropertyArrayHelper(PropertyBag bag, Integer countID) {
        Property countProp;
        this.m_bag = bag;
        this.m_countID = countID;
        this.m_baseID = 1;
        if (this.m_countID != null && (countProp = this.m_bag.getItem(this.m_countID)) == null) {
            this.m_bag.setProperty((Object)this.m_countID, new Integer(0));
        }
    }

    public PropertyArrayHelper(PropertyBag bag) {
        this.m_bag = bag;
        this.m_baseID = 0;
        this.m_countID = null;
    }

    public Property add(Object value, int flag) {
        int size = this.size();
        Integer newID = this.getIndexID(size);
        Property prop = this.m_bag.addItem(newID, value, flag);
        if (this.m_countID != null) {
            this.m_bag.setProperty((Object)this.m_countID, new Integer(size + 1));
        }
        return prop;
    }

    public Property[] addAll(Object[] values, int flag) {
        int i;
        int size = this.size();
        Property[] result = new Property[values.length];
        for (i = 0; i < values.length; ++i) {
            Object value = values[i];
            Integer newID = this.getIndexID(size + i);
            result[i] = this.m_bag.addItem(newID, value, flag);
        }
        if (this.m_countID != null) {
            this.m_bag.setProperty((Object)this.m_countID, new Integer(size + i));
        }
        return result;
    }

    public void add(int index, Object value) {
        int lastIndex = this.size();
        int flag = value instanceof PropertyBag ? 0x8000000 : 0;
        Object temp = this.add(value, flag).getValue();
        for (int i = this.size() - 1; i > index; --i) {
            this.moveValue(i - 1, i, flag);
        }
        Property prop = this.getProperty(index > lastIndex ? lastIndex : index);
        if (temp instanceof PropertyBag) {
            prop.setRawValue(temp);
            PropertyBag bag = prop.getPropertyBag();
            bag.removeAllLocal();
            bag.putAll((Map)((PropertyBag)value));
            if (((PropertyBag)value).isTopLevel()) {
                bag.setTopLevel(true);
            }
        } else {
            prop.setValue(value);
        }
    }

    public boolean addAll(int index, Collection c) {
        if (c.size() <= 0) {
            return false;
        }
        Iterator iter = c.iterator();
        Object value = iter.next();
        boolean isBag = value instanceof PropertyBag;
        int flags = isBag ? 0x8000000 : 0;
        int lastIndex = this.size();
        Property[] props = this.addAll(c.toArray(), flags);
        int pos = index;
        if (index < lastIndex) {
            int i;
            Object[] values = new Object[props.length];
            for (int i2 = props.length - 1; i2 >= 0; --i2) {
                values[i2] = props[i2].getRawValue();
            }
            int dist = c.size();
            for (i = this.size() - 1; i >= index + dist; --i) {
                this.moveValue(i - dist, i, flags);
            }
            for (i = values.length - 1; i >= 0; --i) {
                Property prop = this.getProperty(i + index);
                if (prop == null) {
                    prop = this.m_bag.addItem(this.getIndexID(i + index), values[i], flags);
                }
                prop.setRawValue(values[i]);
            }
        } else {
            pos = lastIndex;
        }
        if (isBag) {
            while (true) {
                PropertyBag bag = this.getProperty(pos).getPropertyBag();
                bag.removeAllLocal();
                bag.putAll((Map)((PropertyBag)value));
                if (!iter.hasNext()) break;
                value = iter.next();
                ++pos;
            }
        }
        return true;
    }

    private void moveValue(int src, int dest, int flags) {
        Property destProp = this.getProperty(dest);
        Property srcProp = this.getProperty(src);
        if (srcProp == null) {
            if (destProp != null) {
                this.m_bag.removeLocal(destProp.getID());
            }
        } else {
            if (destProp == null) {
                destProp = this.m_bag.addItem(this.getIndexID(src), srcProp.getRawValue(), flags);
            }
            destProp.setRawValue(srcProp.getRawValue());
        }
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public Object get(int index) {
        if (index >= this.size()) {
            throw new NoSuchElementException();
        }
        Property prop = this.m_bag.getItem(this.getIndexID(index));
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public Object remove(int index) {
        int size = this.size();
        Object oldValue = this.get(index);
        for (int i = index; i < size - 1; ++i) {
            Property thisProp = this.getProperty(i);
            thisProp.setRawValue(this.getProperty(i + 1).getRawValue());
        }
        this.m_bag.removeLocal(this.getIndexID(size - 1));
        if (this.m_countID != null) {
            this.m_bag.setProperty((Object)this.m_countID, new Integer(size - 1));
        }
        return oldValue;
    }

    public Object set(int index, Object element) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Property old = this.getProperty(index);
        if (old != null) {
            Object oldValue = old.getValue();
            this.m_bag.setProperty((Object)this.getIndexID(index), element);
            return oldValue;
        }
        this.m_bag.addItem(this.getIndexID(index), element, 0);
        return null;
    }

    public int size() {
        if (this.m_countID == null) {
            return this.m_bag.size();
        }
        Property countProp = this.m_bag.getItem(this.m_countID);
        int count = countProp == null ? 0 : countProp.getInt();
        return count;
    }

    private Property getProperty(int index) {
        return this.m_bag.getItem(this.getIndexID(index));
    }

    private Integer getIndexID(int index) {
        return new Integer(this.m_baseID + index);
    }
}

