/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.EmptyCollections;
import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IPropertyChangeListener;
import com.crystaldecisions.celib.properties.IPropertyFactory;
import com.crystaldecisions.celib.properties.LocaleIDs;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.stringhandler.StringHandler;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PropertyBag
implements IPropertyChangeListener,
Map {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.properties.PropertyBag");
    private static final IPropertyFactory s_defaultFactory = new DefaultPropertyFactory();
    private Map m_mapByID = new HashMap();
    private Map m_hiddenMapByID = EmptyCollections.MAP;
    private IPropertyChangeListener m_listener;
    private IBagUnpacker.IBagUnpackerFactory m_unpackerFactory;
    private IPropertyFactory m_factory;
    private boolean m_dirty = false;
    private StringHandler m_encrypter;
    private static final Integer SIZE_PROP = IDHelper.define("SI_TOTAL");
    private boolean m_topLevel;

    public PropertyBag() {
        this(null);
    }

    public PropertyBag(IPropertyFactory factory) {
        this.m_factory = factory == null ? s_defaultFactory : factory;
        this.m_dirty = false;
        this.m_topLevel = false;
    }

    public Property addItem(Object id, Object value, int flags) {
        return this.addHelper(id, value, flags, null);
    }

    public Property addPropertyBag(Object id, IPropertyChangeListener listener) {
        return this.addHelper(id, null, 0x8000000, listener);
    }

    protected Property addHelper(Object id, Object value, int flags, IPropertyChangeListener listener) {
        boolean deleteProp;
        if ((flags & 0x8000000) != 0) {
            value = this.m_factory.makePropertyBag();
            if (listener != null) {
                ((PropertyBag)value).addPropertyChangeListener(listener);
            }
            ((PropertyBag)value).m_unpackerFactory = this.m_unpackerFactory;
        }
        Integer realId = IDHelper.object2Integer(id);
        LOG.assertNotNull((Object)realId, "realId is null.");
        if ((flags & 0x800000) != 0 && value instanceof String && this.m_encrypter != null) {
            value = this.m_encrypter.pack((String)value);
        }
        boolean bl = deleteProp = (flags & 0x4000000) != 0;
        if (deleteProp) {
            value = null;
            if (this.get(id) != null) {
                return (Property)this.remove(id);
            }
        }
        Property prop = this.m_factory.makeProperty(realId, value, flags | 0x20000000, this);
        this.putProperty(realId, prop);
        this.propertyChange(prop);
        return prop;
    }

    public Property addArray(Object id) {
        Property property = this.addItem(id, null, 0x8000000);
        PropertyBag bag = property.getPropertyBag();
        bag.setProperty((Object)SIZE_PROP, 0);
        return property;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.m_listener = listener;
    }

    public boolean hasPropertyChangeListener() {
        return this.m_listener != null;
    }

    public void cleanupChanges() {
        Iterator<Object> iter = this.values().iterator();
        Iterator hiddenIter = this.m_hiddenMapByID.values().iterator();
        while (iter.hasNext() || iter != hiddenIter && (iter = hiddenIter).hasNext()) {
            Property property = (Property)iter.next();
            int flags = property.getFlags();
            if ((flags & 0x4000000) != 0) {
                iter.remove();
                continue;
            }
            property.setFlags(flags & 0xDFFFFFFF);
        }
        this.m_dirty = false;
    }

    public void clear() {
        Iterator iter = this.m_mapByID.values().iterator();
        Iterator hiddenIter = this.m_hiddenMapByID.values().iterator();
        while (iter.hasNext() || iter != hiddenIter && (iter = hiddenIter).hasNext()) {
            Property prop = (Property)iter.next();
            prop.setRawValue(null);
        }
    }

    public boolean containsKey(Object key) {
        return this.m_mapByID.containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public PropertyBag copy() {
        Property prop;
        PropertyBag copy = this.m_factory.makePropertyBag();
        copy.m_unpackerFactory = this.m_unpackerFactory;
        copy.m_encrypter = this.m_encrypter;
        Iterator iter = this.m_mapByID.values().iterator();
        while (iter.hasNext()) {
            prop = (Property)iter.next();
            prop = prop.copyTo(copy);
            copy.m_mapByID.put(prop.getID(), prop);
        }
        iter = this.m_hiddenMapByID.values().iterator();
        if (iter.hasNext()) {
            copy.m_hiddenMapByID = new HashMap(this.m_hiddenMapByID.values().size(), 1.0f);
            do {
                prop = (Property)iter.next();
                prop = prop.copyTo(copy);
                copy.m_hiddenMapByID.put(prop.getID(), prop);
            } while (iter.hasNext());
        }
        return copy;
    }

    public Object removeLocal(Object key) {
        Integer realId = IDHelper.object2Integer(key);
        Object old = this.m_mapByID.remove(realId);
        if (old == null) {
            old = this.m_hiddenMapByID.remove(realId);
        }
        if (old != null) {
            this.m_dirty = true;
            this.propertyChange((Property)old);
        }
        return old;
    }

    public Set entrySet() {
        return this.m_mapByID.entrySet();
    }

    public Object get(Object key) {
        return this.getItem(key);
    }

    public boolean getBoolean(Object id) {
        Property property = this.getItem(id);
        return property != null ? property.getBoolean() : false;
    }

    public Date getDate(Object id) {
        Property property = this.getItem(id);
        return property != null ? property.getDate() : null;
    }

    public double getDouble(Object id) {
        Property property = this.getItem(id);
        return property != null ? property.getDouble() : 0.0;
    }

    IPropertyFactory getFactory() {
        return this.m_factory;
    }

    public int getInt(Object id) {
        Property property = this.getItem(id);
        return property != null ? property.getInt() : 0;
    }

    public Property getItem(Object id) {
        Integer realId = IDHelper.object2Integer(id);
        Property prop = (Property)this.m_mapByID.get(realId);
        if (prop == null) {
            LOG.assertNotNull((Object)realId, "realId is null.");
            return (Property)this.m_hiddenMapByID.get(realId);
        }
        return prop;
    }

    public long getLong(Object id) {
        Property property = this.getItem(id);
        return property != null ? property.getLong() : 0L;
    }

    public PropertyBag getPropertyBag(Object id) {
        Property property = this.getItem(id);
        return property != null ? property.getPropertyBag() : null;
    }

    public String getString(Object id) {
        Property property = this.getItem(id);
        return property != null ? property.getString() : null;
    }

    public String getString(Locale loc) throws Exception {
        String locale = loc.toString().toUpperCase();
        Property property = this.getItem(locale);
        if (property == null || property.getValue() == null) {
            int index;
            boolean isChinese = locale.startsWith("ZH");
            boolean isSerbian = locale.startsWith("SR");
            if (!isChinese && !isSerbian && (index = locale.indexOf("_")) != -1) {
                locale = locale.substring(0, index);
                property = this.getItem(LocaleIDs.nameToID(locale));
            }
            if (property == null || property.getValue() == null) {
                property = this.getItem(LocaleIDs.EN);
            }
            if (property == null || property.getValue() == null) {
                Set allLocales = this.keySet();
                Iterator iter = allLocales.iterator();
                boolean stringFound = false;
                while (iter.hasNext()) {
                    property = this.getItem(iter.next());
                    if (property == null || property.getValue() == null) continue;
                    stringFound = true;
                    break;
                }
                if (!stringFound) {
                    LOG.error((Object)"No string exists in multilingual bag.");
                    throw new NoSuchElementException(locale.toString());
                }
            }
        }
        return property.getString();
    }

    IBagUnpacker.IBagUnpackerFactory getUnpackerFactory() {
        return this.m_unpackerFactory;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public boolean isEmpty() {
        return this.m_mapByID.isEmpty();
    }

    public Set keySet() {
        return this.m_mapByID.keySet();
    }

    private void notifyPropertyChange(Property changed) {
        if (this.m_listener != null) {
            this.m_listener.propertyChange(changed);
        }
    }

    public void propertyChange(Property changed) {
        this.m_dirty = true;
        this.notifyPropertyChange(changed);
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        this.putAll(t, true);
    }

    private void putAll(Map t, boolean performEncryption) {
        if (!(t instanceof PropertyBag)) {
            throw new UnsupportedOperationException();
        }
        PropertyBag otherBag = (PropertyBag)t;
        Iterator iterator = otherBag.allIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            this.addProperty(property, performEncryption);
        }
        if (this.m_unpackerFactory == null) {
            this.m_unpackerFactory = otherBag.m_unpackerFactory;
        }
    }

    public void putAllWithoutEncryption(Map t) {
        this.putAll(t, false);
    }

    public Object remove(Object key) {
        Property prop = (Property)this.get(key);
        if (prop != null) {
            prop.setRawValue(null);
        }
        return prop;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        LOG.assertTrue(listener == this.m_listener, "removePropertyChangeListener(): listner and m_listner should be the same object");
        this.m_listener = null;
    }

    public void setProperty(Object id, Object value) {
        Property prop = this.getItem(id);
        if (prop != null) {
            prop.setValue(value);
        } else {
            this.addItem(id, value, 0);
        }
    }

    public void setProperty(Object id, int value) {
        this.setProperty(id, IntegerConversion.getDefaultInteger(value));
    }

    public void setProperty(Object id, long value) {
        this.setProperty(id, new Long(value));
    }

    public void setProperty(Object id, boolean value) {
        this.setProperty(id, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setString(Locale locale, String message) {
        this.setProperty((Object)locale, message);
    }

    public int size() {
        return this.m_mapByID.size();
    }

    public String toString() {
        Iterator iter = this.m_mapByID.entrySet().iterator();
        StringWriter sw = new StringWriter();
        sw.write("(");
        while (iter.hasNext()) {
            Map.Entry o = iter.next();
            sw.write("(");
            sw.write(IDHelper.idToName((Integer)o.getKey()));
            sw.write(" ");
            sw.write(o.getValue().toString());
            sw.write(")");
            if (!iter.hasNext()) continue;
            sw.write(" ");
        }
        sw.write(")");
        return sw.getBuffer().toString();
    }

    public void unpack(IBagUnpacker unpacker) {
        this.m_mapByID.clear();
        this.m_hiddenMapByID.clear();
        this.merge(unpacker);
    }

    public void merge(IBagUnpacker unpacker, boolean notifyChange, boolean isTopLevelOnly) {
        this.m_unpackerFactory = unpacker.getNestedUnpackerFactory();
        while (unpacker.hasNext()) {
            IBagUnpacker.Output desc = (IBagUnpacker.Output)unpacker.next();
            if (desc == IBagUnpacker.Output.UNSUPPORTEDTYPE) continue;
            Property prop = this.m_factory.makeProperty(desc.m_id, desc.m_value, desc.m_flags, desc.m_type, this);
            if (prop.isContainer() && this.getPropertyBag(desc.m_id) != null) {
                if (isTopLevelOnly) {
                    this.remove(desc.m_id);
                    this.putProperty(desc.m_id, prop);
                    if (!notifyChange) continue;
                    this.propertyChange(prop);
                    continue;
                }
                IBagUnpacker nestedBagUnpacker = this.m_unpackerFactory.makeUnpacker();
                nestedBagUnpacker.initialize(desc.m_value);
                this.getPropertyBag(desc.m_id).merge(nestedBagUnpacker, notifyChange);
                continue;
            }
            this.putProperty(desc.m_id, prop);
            if (!notifyChange) continue;
            this.propertyChange(prop);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("merge(): size=" + this.m_mapByID.size()));
        }
    }

    public void merge(IBagUnpacker unpacker) {
        this.merge(unpacker, false);
    }

    public void merge(IBagUnpacker unpacker, boolean notifyChange) {
        this.merge(unpacker, notifyChange, false);
    }

    void addProperty(Property prop, boolean performEncryption) {
        Integer id = prop.getID();
        Property myProp = this.getItem(id);
        if (myProp == null || (myProp.getFlags() & 0x4000000) != 0) {
            if (performEncryption && (prop.getFlags() & 0x800000) != 0) {
                this.addItem(id, prop.getValue(), prop.getFlags());
            } else {
                this.putProperty(id, prop.copyTo(this, performEncryption));
                myProp = this.getItem(id);
                myProp.notifyPropertyChange();
            }
        } else {
            LOG.assertTrue(myProp.isContainer() == prop.isContainer(), "addProperty(): flags should be the same");
            if (myProp.isContainer()) {
                PropertyBag myBag = myProp.getPropertyBag();
                if (myBag.isEmpty() && myBag.m_hiddenMapByID.isEmpty()) {
                    myProp.cloneFrom(prop, performEncryption);
                } else {
                    PropertyBag bag = prop.getPropertyBag();
                    if (bag == null) {
                        myProp.cloneFrom(prop, performEncryption);
                    } else if (performEncryption) {
                        myBag.putAll((Map)bag);
                    } else {
                        myBag.putAllWithoutEncryption(bag);
                    }
                }
            } else {
                myProp.cloneFrom(prop, performEncryption);
            }
        }
    }

    public void cloneFromNonValueProperties(PropertyBag other) {
        this.m_unpackerFactory = other.m_unpackerFactory;
        this.m_encrypter = other.m_encrypter;
    }

    public Collection values() {
        return this.m_mapByID.values();
    }

    public Collection hiddenValues() {
        return this.m_hiddenMapByID.values();
    }

    public Iterator allIterator() {
        return new Iterator(){
            private Iterator m_current;
            private final Iterator m_hiddenIter;
            {
                this.m_current = PropertyBag.this.m_mapByID.values().iterator();
                this.m_hiddenIter = PropertyBag.this.m_hiddenMapByID.values().iterator();
            }

            public boolean hasNext() {
                if (!this.m_current.hasNext()) {
                    if (this.m_current == this.m_hiddenIter) {
                        return false;
                    }
                    this.m_current = this.m_hiddenIter;
                    return this.m_current.hasNext();
                }
                return true;
            }

            public Object next() {
                try {
                    return this.m_current.next();
                }
                catch (NoSuchElementException e) {
                    if (this.m_current != this.m_hiddenIter) {
                        this.m_current = this.m_hiddenIter;
                        return this.m_current.next();
                    }
                    throw e;
                }
            }

            public void remove() {
                this.m_current.remove();
            }
        };
    }

    public StringHandler getStringHandler() {
        return this.m_encrypter;
    }

    public void setStringHandler(StringHandler encrypter) {
        this.m_encrypter = encrypter;
    }

    private void putProperty(Integer id, Property prop) {
        int flags = prop.getFlags();
        if ((flags & 0x1000000) != 0) {
            if (this.m_mapByID.get(id) != null) {
                prop.cleanFlag(0x1000000);
                this.m_mapByID.put(id, prop);
            } else {
                if (this.m_hiddenMapByID == EmptyCollections.MAP) {
                    this.m_hiddenMapByID = new HashMap(1, 1.0f);
                }
                this.m_hiddenMapByID.put(id, prop);
            }
        } else if (this.m_hiddenMapByID.get(id) != null) {
            prop.setFlag(0x1000000);
            this.m_hiddenMapByID.put(id, prop);
        } else {
            this.m_mapByID.put(id, prop);
        }
    }

    public void removeAllLocal() {
        Property prop;
        Iterator iter = this.m_mapByID.values().iterator();
        while (iter.hasNext()) {
            prop = (Property)iter.next();
            iter.remove();
            this.propertyChange(prop);
        }
        iter = this.m_hiddenMapByID.values().iterator();
        while (iter.hasNext()) {
            prop = (Property)iter.next();
            iter.remove();
            this.propertyChange(prop);
        }
    }

    public void touchAll() {
        Iterator iter = this.allIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            prop.setFlag(0x20000000);
        }
        this.m_dirty = true;
    }

    public void setTopLevel(boolean topLevel) {
        this.m_topLevel = topLevel;
    }

    public boolean isTopLevel() {
        return this.m_topLevel;
    }

    private static class DefaultPropertyFactory
    implements IPropertyFactory {
        private DefaultPropertyFactory() {
        }

        public Property makeProperty(Integer id, Object value, int flag, PropertyBag container) {
            return new Property(id, value, flag, container);
        }

        public Property makeProperty(Integer id, Object value, int flag, int type, PropertyBag container) {
            return new Property(id, value, flag, type, container);
        }

        public PropertyBag makePropertyBag() {
            return new PropertyBag();
        }
    }
}

