/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import java.util.Comparator;

public class PropertyBagComparator
implements Comparator {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.properties.PropertyBagComparator");
    private Integer[] m_IDs;
    private boolean[] m_ascdenings;

    public PropertyBagComparator(Integer[] IDs, boolean[] ascdenings) {
        LOG.assertTrue(IDs.length == ascdenings.length, "PropertyBagComparator(): IDs and ascdenings should have the same length");
        this.m_IDs = IDs;
        this.m_ascdenings = ascdenings;
    }

    public PropertyBagComparator(Integer[] IDs) {
        this.m_IDs = IDs;
        this.m_ascdenings = new boolean[IDs.length];
        for (int i = 0; i < this.m_ascdenings.length; ++i) {
            this.m_ascdenings[i] = true;
        }
    }

    public int compare(Object o1, Object o2) {
        LOG.assertTrue(o1 instanceof PropertyBag && o2 instanceof PropertyBag, "compare(): o1 and o2 should all be PropertyBag");
        PropertyBag bag1 = (PropertyBag)o1;
        PropertyBag bag2 = (PropertyBag)o2;
        for (int i = 0; i < this.m_IDs.length; ++i) {
            Integer id = this.m_IDs[i];
            boolean ascending = this.m_ascdenings[i];
            Property prop1 = bag1.getItem(id);
            Property prop2 = bag2.getItem(id);
            if (prop1 == null) {
                if (prop2 == null) continue;
                return ascending ? -1 : 1;
            }
            if (prop2 == null) {
                return ascending ? 1 : -1;
            }
            int compared = prop1.compareTo(prop2);
            if (compared == 0) continue;
            return ascending ? compared : -compared;
        }
        return 0;
    }
}

