/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyArrayHelper;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.StringWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class QBSet {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.properties.QBSet");
    private Map m_indexes;
    private Set m_bags = new HashSet();
    private Map m_comparators;

    public QBSet(Integer[] indexIDs) {
        this(indexIDs, null);
    }

    public QBSet(Integer[] indexIDs, Comparator[] comparators) {
        this.m_indexes = new HashMap();
        this.m_comparators = new HashMap();
        for (int i = 0; i < indexIDs.length; ++i) {
            Integer id = indexIDs[i];
            if (comparators != null) {
                Comparator comparator = comparators[i];
                if (comparator != null) {
                    this.m_indexes.put(id, new TreeMap(comparator));
                    this.m_comparators.put(id, comparator);
                    continue;
                }
                this.m_indexes.put(id, new HashMap());
                continue;
            }
            this.m_indexes.put(id, new HashMap());
        }
    }

    public void addIndex(Integer id, Comparator comp) {
        if (id != null) {
            if (comp != null) {
                this.m_indexes.put(id, new TreeMap(comp));
                this.m_comparators.put(id, comp);
            } else {
                this.m_indexes.put(id, new HashMap());
            }
        }
    }

    public Set bags() {
        return this.m_bags;
    }

    public boolean containsAll(Set set) {
        if (this.size() < set.size()) {
            return false;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            PropertyBag bag = (PropertyBag)iter.next();
            if (this.contains(bag)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(PropertyBag bag) {
        if (this.m_bags.contains(bag)) {
            return true;
        }
        return this.find(bag).size() != 0;
    }

    private Set find(PropertyBag bag) {
        Query query = new Query();
        Iterator iter = bag.keySet().iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            Property prop = bag.getItem(id);
            if (prop == null) continue;
            List values = this.extractValues(prop.getValue());
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value == null) continue;
                query.addTerm(id, value);
            }
        }
        Set matches = this.query(query);
        Iterator iterator = matches.iterator();
        block2: while (iterator.hasNext()) {
            PropertyBag match = (PropertyBag)iterator.next();
            if (match.size() != bag.size()) {
                iterator.remove();
                continue;
            }
            Iterator ids = match.keySet().iterator();
            while (ids.hasNext()) {
                Comparator comparator;
                List bagValues;
                Object bagValue;
                Integer id = (Integer)ids.next();
                Object value = match.getItem(id).getValue();
                List values = this.extractValues(value);
                Property bagProp = bag.getItem(id);
                if (bagProp != null && (bagValue = bagProp.getValue()) != null && this.compareCollections(values, bagValues = this.extractValues(bagValue), comparator = (Comparator)this.m_comparators.get(id))) continue;
                iterator.remove();
                continue block2;
            }
        }
        return matches;
    }

    public boolean add(PropertyBag bag) {
        if (!this.contains(bag)) {
            this.m_bags.add(bag);
            Iterator iter = this.m_indexes.keySet().iterator();
            while (iter.hasNext()) {
                Integer id = (Integer)iter.next();
                Map index = (Map)this.m_indexes.get(id);
                Property prop = bag.getItem(id);
                if (prop == null) continue;
                Object value = prop.getValue();
                List values = this.extractValues(value);
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    HashSet<PropertyBag> matches = (HashSet<PropertyBag>)index.get(key);
                    if (matches == null) {
                        matches = new HashSet<PropertyBag>();
                        index.put(key, matches);
                    }
                    matches.add(bag);
                }
            }
            return true;
        }
        return false;
    }

    public void addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add((PropertyBag)iter.next());
        }
    }

    public void addAll(PropertyBag[] bags) {
        for (int i = 0; i < bags.length; ++i) {
            this.add(bags[i]);
        }
    }

    public PropertyBag get(Integer id, String value) {
        Query q = new Query();
        q.addTerm(id, value);
        Set results = this.query(q);
        LOG.assertTrue(results.size() <= 1, "get(): shoulnd't have more than one matches");
        if (results.size() == 0) {
            return null;
        }
        return (PropertyBag)results.iterator().next();
    }

    public Set query(Query query) {
        HashSet results = new HashSet(this.m_bags);
        Set terms = query.getTerms();
        HashSet<QueryTerm> unIndexedTerms = new HashSet<QueryTerm>();
        Iterator iter = terms.iterator();
        while (iter.hasNext() && results.size() > 0) {
            QueryTerm term = (QueryTerm)iter.next();
            Map index = (Map)this.m_indexes.get(term.getID());
            if (index != null) {
                Set matches = (Set)index.get(term.getValue());
                if (matches != null) {
                    results.retainAll(matches);
                    continue;
                }
                results.clear();
                continue;
            }
            unIndexedTerms.add(term);
        }
        if (results.size() > 0) {
            this.continueQuery(unIndexedTerms, results);
        }
        return results;
    }

    private void continueQuery(Set terms, Set results) {
        if (terms.size() > 0) {
            Iterator resultItr = results.iterator();
            block0: while (resultItr.hasNext()) {
                PropertyBag bag = (PropertyBag)resultItr.next();
                Iterator itr = terms.iterator();
                while (itr.hasNext()) {
                    QueryTerm term = (QueryTerm)itr.next();
                    Integer id = term.getID();
                    Property prop = bag.getItem(id);
                    if (prop != null) {
                        Object value = prop.getValue();
                        Object toBeFound = term.getValue();
                        if (value != null) {
                            List values;
                            if (toBeFound instanceof String && !term.isCaseSensitive()) {
                                toBeFound = new StringWrapper((String)toBeFound);
                            }
                            if ((values = this.extractValues(value)).contains(toBeFound)) continue;
                            resultItr.remove();
                            continue block0;
                        }
                        if (toBeFound == null) continue;
                        resultItr.remove();
                        continue block0;
                    }
                    resultItr.remove();
                    continue block0;
                }
            }
        }
    }

    public void remove(PropertyBag bag) {
        HashSet<PropertyBag> bagsInSet;
        if (!this.m_bags.remove(bag)) {
            bagsInSet = this.find(bag);
            if (!this.m_bags.removeAll(bagsInSet)) {
                return;
            }
        } else {
            bagsInSet = new HashSet<PropertyBag>();
            bagsInSet.add(bag);
        }
        Iterator bagIter = bagsInSet.iterator();
        while (bagIter.hasNext()) {
            PropertyBag propertyBag = (PropertyBag)bagIter.next();
            Iterator iter = this.m_indexes.keySet().iterator();
            while (iter.hasNext()) {
                Integer id = (Integer)iter.next();
                Property prop = propertyBag.getItem(id);
                if (prop == null) continue;
                Map index = (Map)this.m_indexes.get(id);
                Object value = prop.getValue();
                List values = this.extractValues(value);
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    Set matches = (Set)index.get(key);
                    if (matches == null) continue;
                    matches.remove(propertyBag);
                    if (!matches.isEmpty()) continue;
                    index.remove(key);
                }
            }
        }
    }

    public void set(Collection bags, Integer id, Object newValue) {
        if (bags.size() == 0) {
            return;
        }
        Map index = (Map)this.m_indexes.get(id);
        Comparator comp = (Comparator)this.m_comparators.get(id);
        if (index != null) {
            List newValues = this.extractValues(newValue);
            Iterator iterator = newValues.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                HashSet<PropertyBag> newMatches = (HashSet<PropertyBag>)index.get(value);
                if (newMatches == null) {
                    newMatches = new HashSet<PropertyBag>(bags.size());
                    index.put(value, newMatches);
                }
                Iterator iter = bags.iterator();
                while (iter.hasNext()) {
                    PropertyBag bag = (PropertyBag)iter.next();
                    Property property = bag.getItem(id);
                    if (property != null) {
                        Object oldVal = property.getValue();
                        List oldValues = this.extractValues(oldVal);
                        Iterator oldValItr = oldValues.iterator();
                        while (oldValItr.hasNext()) {
                            Set matches;
                            Object oldValue = oldValItr.next();
                            if (this.contains(newValues, oldValue, comp) || (matches = (Set)index.get(oldValue)) == null) continue;
                            matches.remove(bag);
                        }
                        property.setRawValue(newValue);
                    } else {
                        bag.setProperty((Object)id, value);
                    }
                    newMatches.add(bag);
                }
            }
        } else {
            Iterator iterator = bags.iterator();
            while (iterator.hasNext()) {
                PropertyBag bag = (PropertyBag)iterator.next();
                bag.setProperty((Object)id, newValue);
            }
        }
    }

    private boolean contains(Collection values, Object value, Comparator comp) {
        if (comp == null) {
            return values.contains(value);
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!value.equals(o) && comp.compare(o, value) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean compareCollections(Collection values1, Collection values2, Comparator comp) {
        if (values1 == null || values2 == null) {
            return values1 == values2;
        }
        if (values1.size() != values2.size()) {
            return false;
        }
        if (comp == null) {
            return ((Object)values1).equals(values2);
        }
        if (values1 instanceof List && values2 instanceof List) {
            Iterator iter1 = values1.iterator();
            Iterator iter2 = values2.iterator();
            while (iter2.hasNext()) {
                if (comp.compare(iter1.next(), iter2.next()) == 0) continue;
                return false;
            }
            return true;
        }
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void set(PropertyBag[] bags, Integer id, Object value) {
        this.set(Arrays.asList(bags), id, value);
    }

    public void set(PropertyBag bag, Integer id, Object value) {
        this.set(new PropertyBag[]{bag}, id, value);
    }

    public void removeAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.remove((PropertyBag)iter.next());
        }
    }

    public void removeAll(PropertyBag[] bags) {
        for (int i = 0; i < bags.length; ++i) {
            this.remove(bags[i]);
        }
    }

    public int size() {
        return this.m_bags.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator iterator = this.m_bags.iterator();
        while (iterator.hasNext()) {
            PropertyBag bag = (PropertyBag)iterator.next();
            result.append(bag + "\n");
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List extractValues(Object value) {
        void var2_2;
        ArrayList<Object> values;
        if (value instanceof PropertyBag) {
            values = new PropertyArrayHelper((PropertyBag)value, IDHelper.define("SI_TOTAL"));
        } else if (value instanceof List) {
            values = (ArrayList<Object>)value;
        } else if (value != null) {
            values = new ArrayList<Object>(1);
            values.add(value);
        } else {
            throw new IllegalArgumentException("null");
        }
        return var2_2;
    }

    private static class QueryTerm {
        private Integer m_id;
        private Object m_value;
        private boolean m_caseSensitive = false;

        public QueryTerm(Integer id, Object value) {
            this.m_id = id;
            this.m_value = value;
        }

        public QueryTerm(Integer id, Object value, boolean caseSensitive) {
            this.m_id = id;
            this.m_value = value;
            this.m_caseSensitive = caseSensitive;
        }

        public Integer getID() {
            return this.m_id;
        }

        public Object getValue() {
            return this.m_value;
        }

        public boolean isCaseSensitive() {
            return this.m_caseSensitive;
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueryTerm) {
                QueryTerm queryTerm = (QueryTerm)obj;
                return queryTerm.getID().equals(this.m_id);
            }
            return false;
        }

        public int hashCode() {
            return this.m_id.hashCode();
        }
    }

    public static class Query {
        private Set m_terms = new HashSet();

        public void addTerm(Integer id, Object value) {
            this.m_terms.add(new QueryTerm(id, value));
        }

        public void addTerm(Integer id, Object value, boolean caseSensitive) {
            this.m_terms.add(new QueryTerm(id, value, caseSensitive));
        }

        public void clear() {
            this.m_terms.clear();
        }

        public void removeTerm(Integer id) {
            Iterator itr = this.m_terms.iterator();
            while (itr.hasNext()) {
                QueryTerm term = (QueryTerm)itr.next();
                if (!term.getID().equals(id)) continue;
                itr.remove();
            }
        }

        private Set getTerms() {
            return this.m_terms;
        }
    }
}

