/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.crystaldecisions.celib.parser.FunctionCall;
import com.crystaldecisions.celib.parser.Operator;
import com.crystaldecisions.celib.parser.RelationalOperator;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.QBSet;
import java.util.List;

public class QueryEngine {
    private static final String FUNC_PROPERTY_LIST_CONTAINS = "propertyListContains";

    public static void execute(QBSet.Query query, Operator op) {
        switch (op.getType()) {
            case 0: {
                QueryEngine.runFunctionCall(query, (FunctionCall)op);
                break;
            }
            case 1: {
                QueryEngine.runRelationOp(query, (RelationalOperator)op);
                break;
            }
        }
    }

    private static void runFunctionCall(QBSet.Query query, FunctionCall op) {
        List args;
        if (op.getValue().equalsIgnoreCase(FUNC_PROPERTY_LIST_CONTAINS) && (args = op.getArguments()).size() == 2) {
            String propName = (String)args.get(0);
            Object value = args.get(1);
            query.addTerm(IDHelper.nameToID(propName), value);
        }
    }

    private static void runRelationOp(QBSet.Query query, RelationalOperator rlop) {
        if (rlop.getValue().equals("=")) {
            String propName = (String)rlop.getLeftArgument();
            Object value = rlop.getRightArgument();
            query.addTerm(IDHelper.nameToID(propName), value);
        }
    }
}

