/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.URLDecoder;

public class URLUnpacker
implements IBagUnpacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.properties.URLUnpacker");
    private static final IBagUnpacker.IBagUnpackerFactory s_bagUnpackerFactory = new URLUnpackerFactory();
    private String m_url;
    private int m_offset;
    private char m_delimiter;

    public URLUnpacker() {
        this.m_url = null;
        this.m_delimiter = (char)38;
    }

    public URLUnpacker(char delimiter) {
        this.m_delimiter = delimiter;
    }

    public void initialize(Object src) {
        String url;
        LOG.assertTrue(src instanceof String, "initialize(): src should be string");
        this.m_url = url = (String)src;
        this.m_offset = 0;
    }

    public IBagUnpacker.IBagUnpackerFactory getNestedUnpackerFactory() {
        return s_bagUnpackerFactory;
    }

    public boolean hasNext() {
        LOG.assertNotNull((Object)this.m_url, "m_url is null.");
        return this.m_offset < this.m_url.length();
    }

    public Object next() {
        if (this.hasNext()) {
            int eq = this.m_url.indexOf(61, this.m_offset);
            LOG.assertTrue(eq != -1, "next(): must have non-empty name");
            int amp = this.m_url.indexOf(this.m_delimiter, eq);
            if (amp == -1) {
                amp = this.m_url.length();
            }
            String name = this.m_url.substring(this.m_offset, eq);
            String valueStr = null;
            try {
                valueStr = URLDecoder.decode(this.m_url.substring(eq + 1, amp));
            }
            catch (Exception e) {
                // empty catch block
            }
            Integer id = IDHelper.nameToID(name);
            this.m_offset = amp + 1;
            return new IBagUnpacker.Output(id, valueStr, 0);
        }
        return null;
    }

    public void remove() {
    }

    private static class URLUnpackerFactory
    implements IBagUnpacker.IBagUnpackerFactory {
        private URLUnpackerFactory() {
        }

        public IBagUnpacker makeUnpacker() {
            return new URLUnpacker();
        }
    }
}

