/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.registry;

import com.crystaldecisions.celib.holder.IntHolder;
import com.crystaldecisions.celib.registry.RegistryDriver;
import com.crystaldecisions.celib.registry.RegistryJNIDriver;
import com.crystaldecisions.celib.registry.UnixRegistryDriver;
import java.util.Iterator;

public class Registry {
    private static boolean useUnixRegistryDriver = false;
    public static final int REG_SZ = 1;
    public static final int REG_DWORD = 4;
    public static final int HKCC = 0;
    public static final int HKCU = 1;
    public static final int HKLM = 2;
    public static final int HKU = 3;
    public static final int REG_OBJ = 0;
    public static final int VALUE = 1;
    public static final int KEY = 2;
    public static final int WINDOWS_REGISTRY = 1;
    public static final int FILE_REGISTRY = 2;
    public static String REGISTRYFILESROOT;
    private RegistryDriver m_driver;

    public Registry(String keyName, String subkey, int key) {
        this.m_driver = useUnixRegistryDriver ? new UnixRegistryDriver() : new RegistryJNIDriver();
        this.m_driver.doCreateRegistryObject(keyName, subkey, key);
    }

    public Registry(String keyName, String subkey, int key, int registryType) {
        this.m_driver = registryType == 1 ? new RegistryJNIDriver() : new UnixRegistryDriver();
        this.m_driver.doCreateRegistryObject(keyName, subkey, key);
    }

    public void appendKey(String subKey) {
        this.m_driver.doAppendKey(subKey);
    }

    public boolean deleteValue(String name) {
        return this.m_driver.doDeleteValue(name);
    }

    public void destroy() {
        this.m_driver.doDestroy(0);
    }

    protected void finalize() {
        this.m_driver.doDestroy(0);
    }

    public String getKeyName() {
        return this.m_driver.doGetKeyName();
    }

    public boolean getType(String name, IntHolder type) {
        return this.m_driver.doGetType(name, type);
    }

    public boolean keyExists() {
        return this.m_driver.doKeyExists();
    }

    public String readValue(String name) {
        return this.m_driver.doReadValue(name);
    }

    public String readValue(String name, int defaultValue) {
        return this.m_driver.doReadValue(name, defaultValue);
    }

    public String readValue(String name, String defaultValue) {
        return this.m_driver.doReadValue(name, defaultValue);
    }

    public void setSubSubKey(String subSubKey) {
        this.m_driver.doSetSubSubKey(subSubKey);
    }

    public Iterator values() {
        return new ValueIterator(this.m_driver.doEnumValues());
    }

    public boolean writeValue(String name, int value) {
        return this.m_driver.doWriteValue(name, value);
    }

    public boolean writeValue(String name, String value) {
        return this.m_driver.doWriteValue(name, value);
    }

    static {
        String osName = System.getProperty("os.name");
        useUnixRegistryDriver = osName == null || osName.indexOf("Windows") != 0;
        REGISTRYFILESROOT = "/Need to specify this/";
    }

    public static class Pair {
        private String m_key;
        private String m_value;

        Pair(String key, String value) {
            this.m_key = key;
            this.m_value = value;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    class ValueIterator
    implements Iterator {
        private int m_handle;
        private boolean m_hasNext;
        private int m_index = 0;

        public ValueIterator(int h) {
            this.m_handle = h;
            this.m_hasNext = this.m_handle != 0;
        }

        protected void finalize() {
            Registry.this.m_driver.doDestroyValueIterator(this.m_handle, 1);
        }

        public boolean hasNext() {
            return this.m_hasNext;
        }

        public int getHandle() {
            return this.m_handle;
        }

        public int getIndex() {
            return this.m_index;
        }

        public void setIndex(int newIndex) {
            this.m_index = newIndex;
        }

        public Object next() {
            if (this.m_hasNext) {
                Pair pair = new Pair(Registry.this.m_driver.doValueGetName(this), Registry.this.m_driver.doValueGetValue(this));
                this.m_hasNext = this.m_handle == 0 ? false : Registry.this.m_driver.doNextValue(this);
                return pair;
            }
            return null;
        }

        public void remove() {
        }
    }
}

