/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.stringhandler;

import com.crystaldecisions.celib.stringhandler.CryptoDES;
import com.crystaldecisions.celib.stringhandler.CryptoSystem;
import com.crystaldecisions.celib.stringhandler.CryptoUtil;
import com.crystaldecisions.celib.stringhandler.StringHandlerException;

public final class Crypto3DES
implements CryptoSystem {
    private static final CryptoDES s_des = new CryptoDES();

    public void encrypt(byte[] i_key, byte[] i_cleartext, int i_clearoffset, long i_IV, byte[] o_cyphertext, int i_cypheroffset) throws StringHandlerException {
        Crypto3DES.doStreamCrypt(i_cleartext, i_clearoffset, o_cyphertext, i_cypheroffset, i_key, i_IV, true);
    }

    public void decrypt(byte[] i_key, byte[] i_cyphertext, int i_cypheroffset, long i_IV, byte[] o_cleartext, int i_clearoffset) throws StringHandlerException {
        Crypto3DES.doStreamCrypt(i_cyphertext, i_cypheroffset, o_cleartext, i_clearoffset, i_key, i_IV, false);
    }

    public int getBlockSize() {
        return s_des.getBlockSize();
    }

    public int getKeySize() {
        return 24;
    }

    private static final void doStreamCrypt(byte[] intext, int in_offset, byte[] outtext, int out_offset, byte[] inkey, long IV, boolean enc) throws StringHandlerException {
        if (intext.length - in_offset > outtext.length - out_offset) {
            throw new StringHandlerException.OutputTooSmall(intext.length - in_offset);
        }
        if (inkey.length != 24) {
            throw new StringHandlerException.WrongKeySize(24);
        }
        CryptoDES.KeySet key1 = new CryptoDES.KeySet(CryptoUtil.b2l(inkey, 0));
        CryptoDES.KeySet key2 = new CryptoDES.KeySet(CryptoUtil.b2l(inkey, 8));
        CryptoDES.KeySet key3 = new CryptoDES.KeySet(CryptoUtil.b2l(inkey, 16));
        if (enc) {
            long processed = IV;
            int in_index = in_offset;
            int out_index = out_offset;
            while (in_index < intext.length) {
                long clear = CryptoUtil.b2l(intext, in_index);
                processed = Crypto3DES.doBlockCrypt(clear ^= processed, key1, key2, key3, true);
                CryptoUtil.l2b(processed, outtext, out_index);
                in_index += 8;
                out_index += 8;
            }
        } else {
            long prevblock = IV;
            int in_index = in_offset;
            int out_index = out_offset;
            while (in_index < intext.length) {
                long crypt = CryptoUtil.b2l(intext, in_index);
                long processed = Crypto3DES.doBlockCrypt(crypt, key3, key2, key1, false);
                prevblock = crypt;
                CryptoUtil.l2b(processed ^= prevblock, outtext, out_index);
                in_index += 8;
                out_index += 8;
            }
        }
    }

    public static final long doBlockCrypt(long plain, CryptoDES.KeySet k1, CryptoDES.KeySet k2, CryptoDES.KeySet k3, boolean enc) {
        plain = CryptoDES.doBlockCrypt(plain, k1, enc);
        plain = CryptoDES.doBlockCrypt(plain, k2, !enc);
        plain = CryptoDES.doBlockCrypt(plain, k3, enc);
        return plain;
    }
}

