/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.stringhandler;

import com.crystaldecisions.celib.stringhandler.CryptoSystem;
import com.crystaldecisions.celib.stringhandler.CryptoUtil;
import com.crystaldecisions.celib.stringhandler.StringHandlerException;

public final class CryptoDES
implements CryptoSystem,
Cloneable {
    private static final int[][] s_sbox = new int[][]{{14, 0, 4, 15, 13, 7, 1, 4, 2, 14, 15, 2, 11, 13, 8, 1, 3, 10, 10, 6, 6, 12, 12, 11, 5, 9, 9, 5, 0, 3, 7, 8, 4, 15, 1, 12, 14, 8, 8, 2, 13, 4, 6, 9, 2, 1, 11, 7, 15, 5, 12, 11, 9, 3, 7, 14, 3, 10, 10, 0, 5, 6, 0, 13}, {15, 3, 1, 13, 8, 4, 14, 7, 6, 15, 11, 2, 3, 8, 4, 14, 9, 12, 7, 0, 2, 1, 13, 10, 12, 6, 0, 9, 5, 11, 10, 5, 0, 13, 14, 8, 7, 10, 11, 1, 10, 3, 4, 15, 13, 4, 1, 2, 5, 11, 8, 6, 12, 7, 6, 12, 9, 0, 3, 5, 2, 14, 15, 9}, {10, 13, 0, 7, 9, 0, 14, 9, 6, 3, 3, 4, 15, 6, 5, 10, 1, 2, 13, 8, 12, 5, 7, 14, 11, 12, 4, 11, 2, 15, 8, 1, 13, 1, 6, 10, 4, 13, 9, 0, 8, 6, 15, 9, 3, 8, 0, 7, 11, 4, 1, 15, 2, 14, 12, 3, 5, 11, 10, 5, 14, 2, 7, 12}, {7, 13, 13, 8, 14, 11, 3, 5, 0, 6, 6, 15, 9, 0, 10, 3, 1, 4, 2, 7, 8, 2, 5, 12, 11, 1, 12, 10, 4, 14, 15, 9, 10, 3, 6, 15, 9, 0, 0, 6, 12, 10, 11, 1, 7, 13, 13, 8, 15, 9, 1, 4, 3, 5, 14, 11, 5, 12, 2, 7, 8, 2, 4, 14}, {2, 14, 12, 11, 4, 2, 1, 12, 7, 4, 10, 7, 11, 13, 6, 1, 8, 5, 5, 0, 3, 15, 15, 10, 13, 3, 0, 9, 14, 8, 9, 6, 4, 11, 2, 8, 1, 12, 11, 7, 10, 1, 13, 14, 7, 2, 8, 13, 15, 6, 9, 15, 12, 0, 5, 9, 6, 10, 3, 4, 0, 5, 14, 3}, {12, 10, 1, 15, 10, 4, 15, 2, 9, 7, 2, 12, 6, 9, 8, 5, 0, 6, 13, 1, 3, 13, 4, 14, 14, 0, 7, 11, 5, 3, 11, 8, 9, 4, 14, 3, 15, 2, 5, 12, 2, 9, 8, 5, 12, 15, 3, 10, 7, 11, 0, 14, 4, 1, 10, 7, 1, 6, 13, 0, 11, 8, 6, 13}, {4, 13, 11, 0, 2, 11, 14, 7, 15, 4, 0, 9, 8, 1, 13, 10, 3, 14, 12, 3, 9, 5, 7, 12, 5, 2, 10, 15, 6, 8, 1, 6, 1, 6, 4, 11, 11, 13, 13, 8, 12, 1, 3, 4, 7, 10, 14, 7, 10, 9, 15, 5, 6, 0, 8, 15, 0, 14, 5, 2, 9, 3, 2, 12}, {13, 1, 2, 15, 8, 13, 4, 8, 6, 10, 15, 3, 11, 7, 1, 4, 10, 12, 9, 5, 3, 6, 14, 11, 5, 0, 0, 14, 12, 9, 7, 2, 7, 2, 11, 1, 4, 14, 1, 7, 9, 4, 12, 10, 14, 8, 2, 13, 0, 15, 6, 12, 10, 9, 13, 0, 15, 3, 3, 5, 5, 6, 8, 11}};
    public static final byte[] s_Initial = new byte[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
    public static final byte[] s_Expand = new byte[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
    static final byte[] s_Pbox = new byte[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
    public static final byte[] s_Final = new byte[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};

    public int getBlockSize() {
        return 8;
    }

    public int getKeySize() {
        return 8;
    }

    CryptoDES() {
    }

    public void decrypt(byte[] i_key, byte[] i_cyphertext, int i_cypheroffset, long i_IV, byte[] o_cleartext, int i_clearoffset) throws StringHandlerException {
        if (o_cleartext.length - i_clearoffset < i_cyphertext.length - i_cypheroffset) {
            throw new StringHandlerException.OutputTooSmall(i_cyphertext.length - i_cypheroffset);
        }
        long key = CryptoUtil.b2l(i_key, 0);
        KeySet keyset = new KeySet(key);
        for (int index = 0; index < o_cleartext.length - i_clearoffset; index += 8) {
            long cypher = CryptoUtil.b2l(i_cyphertext, index + i_cypheroffset);
            long clear = CryptoDES.doBlockCrypt(cypher, keyset, false);
            CryptoUtil.l2b(clear, o_cleartext, index + i_clearoffset);
        }
    }

    public void encrypt(byte[] i_key, byte[] i_cleartext, int i_clearoffset, long i_IV, byte[] o_cyphertext, int i_cypheroffset) throws StringHandlerException {
        if (o_cyphertext.length - i_cypheroffset < i_cleartext.length - i_clearoffset) {
            throw new StringHandlerException.OutputTooSmall(i_cleartext.length - i_clearoffset);
        }
        KeySet keyset = new KeySet(CryptoUtil.b2l(i_key, 0));
        for (int index = 0; index < i_cleartext.length - i_clearoffset; index += 8) {
            long clear = CryptoUtil.b2l(i_cleartext, index + i_clearoffset);
            long cypher = CryptoDES.doBlockCrypt(clear, keyset, true);
            CryptoUtil.l2b(cypher, o_cyphertext, index + i_cypheroffset);
        }
    }

    public static final long doBlockCrypt(long plain, KeySet key, boolean enc) {
        plain = CryptoDES.Permute(plain, s_Initial);
        int R = (int)(plain & 0xFFFFFFFFL);
        int L = (int)(plain >> 32);
        for (int round = 0; round < 16; ++round) {
            long Rexpand = CryptoDES.Permute(R, s_Expand);
            Rexpand = enc ? (Rexpand ^= key.keys[round]) : (Rexpand ^= key.keys[15 - round]);
            Rexpand = CryptoDES.SBoxes(Rexpand);
            Rexpand = CryptoDES.Permute(Rexpand, s_Pbox);
            L = R;
            R = (int)((Rexpand ^= (long)L << 32) >> 32);
        }
        plain = (long)R << 32 | (long)L & 0xFFFFFFFFL;
        plain = CryptoDES.Permute(plain, s_Final);
        return plain;
    }

    private static final long SBoxes(long in) {
        long out = 0L;
        int insw = 58;
        int outsw = 60;
        for (int box = 0; box < 8; ++box) {
            int index = (int)(in >> insw & 0x3FL);
            out |= (long)s_sbox[box][index] << outsw;
            outsw -= 4;
            insw -= 6;
        }
        return out;
    }

    public static final long Permute(long in, byte[] table) {
        long result = 0L;
        for (int i = 0; i < table.length; ++i) {
            long bit = in >> 63 - (table[i] - 1) & 1L;
            result |= bit << 63 - i;
        }
        return result;
    }

    public static final long Permute(int in, byte[] table) {
        return CryptoDES.Permute((long)in << 32, table);
    }

    public static final void trace(String x) {
    }

    static String x(long l) {
        String x = "0000000000000000" + Long.toHexString(l);
        return x.substring(x.length() - 16);
    }

    public static class KeySet
    implements Cloneable {
        public long[] keys = new long[16];
        public long key;
        private static final byte[] s_KeyShift = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 0};
        private static final byte[] s_KeyPerm = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
        private static final byte[] s_Compress = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};

        public KeySet(long k) {
            this.key = k;
            k = CryptoDES.Permute(k, s_KeyPerm);
            for (int i = 0; i < 16; ++i) {
                k = this.KeyShift(k, i);
                this.keys[i] = CryptoDES.Permute(k, s_Compress);
            }
        }

        protected Object clone() {
            try {
                KeySet s = (KeySet)super.clone();
                s.keys = (long[])this.keys.clone();
                return s;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{").append(CryptoDES.x(this.key)).append(":").append(CryptoDES.x(this.keys[0]));
            for (int i = 1; i < 16; ++i) {
                sb.append(" ");
                sb.append(CryptoDES.x(this.keys[i]));
            }
            sb.append('}');
            return sb.toString();
        }

        private final long KeyShift(long key, int round) {
            long R = key >> 8 & 0xFFFFFFFL;
            long L = key >> 36 & 0xFFFFFFFL;
            if (s_KeyShift[round] == 1) {
                R = KeySet.Shift1L(R);
                L = KeySet.Shift1L(L);
            } else {
                R = KeySet.Shift2L(R);
                L = KeySet.Shift2L(L);
            }
            key = L << 36 | R << 8;
            return key;
        }

        public static final long Shift1R(long key) {
            int bit = (int)(key & 1L);
            key >>= 1;
            return key |= (long)(bit << 27);
        }

        public static final long Shift2R(long key) {
            int bits = (int)(key & 3L);
            key >>= 2;
            return key |= (long)(bits << 26);
        }

        public static final long Shift1L(long key) {
            int lowbits = (int)(key >> 27);
            key <<= 1;
            key &= 0xFFFFFFFL;
            return key |= (long)lowbits;
        }

        public static final long Shift2L(long key) {
            int lowbits = (int)(key >> 26);
            key <<= 2;
            key &= 0xFFFFFFFL;
            return key |= (long)lowbits;
        }
    }
}

