/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.stringhandler;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;

public final class CryptoUtil {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.stringhandler.CryptoUtil");

    static boolean isAscii4(char[] in, int index) {
        if (in.length - index < 4) {
            return false;
        }
        for (int i = index; i < index + 4; ++i) {
            if ((in[i] - 48 & 0xC0) <= 0) continue;
            return false;
        }
        return true;
    }

    static int lengthInAscii(int cbBin) {
        int cbOutMessage = cbBin;
        cbOutMessage += 2;
        cbOutMessage /= 3;
        cbOutMessage *= 4;
        return cbOutMessage += 4;
    }

    static void pack4(char[] in, int indexIn, char[] out, int indexOut) {
        out[indexOut++] = (char)((in[indexIn] & 0x3F) + 48);
        out[indexOut++] = (char)(((in[indexIn] & 0xC0) >> 2) + (in[indexIn + 1] & 0xF) + 48);
        out[indexOut++] = (char)(((in[indexIn + 1] & 0xF0) >> 4) + ((in[indexIn + 2] & 0xC0) >> 2) + 48);
        out[indexOut++] = (char)((in[indexIn + 2] & 0x3F) + 48);
    }

    static void unpack3(char[] in, int indexIn, char[] out, int indexOut) {
        char[] temp = new char[4];
        System.arraycopy(in, indexIn, temp, 0, 4);
        temp[0] = (char)(temp[0] - 48);
        temp[1] = (char)(temp[1] - 48);
        temp[2] = (char)(temp[2] - 48);
        temp[3] = (char)(temp[3] - 48);
        out[indexOut++] = (char)(temp[0] | (temp[1] & 0x30) << 2);
        out[indexOut++] = (char)(temp[1] & 0xF | (temp[2] & 0xF) << 4);
        out[indexOut] = (char)(temp[3] | (temp[2] & 0x30) << 2);
    }

    public static final long b2l(byte[] in, int index) {
        return CryptoUtil.b2l(in, index, 8);
    }

    public static final void l2b(long in, byte[] out, int index) {
        CryptoUtil.l2b(in, out, index, 8);
    }

    public static final long b2l(byte[] in, int index, int bytes) {
        long out = 0L;
        if (in.length - index < bytes) {
            LOG.assertTrue(false, "Not enough bytes in input array");
            return 0L;
        }
        for (int nBytes = bytes - 1; nBytes >= 0; --nBytes) {
            out |= (long)(in[index++] & 0xFF) << 8 * nBytes;
        }
        return out;
    }

    public static final void l2b(long in, byte[] out, int index, int bytes) {
        if (out.length - index < bytes) {
            LOG.assertTrue(false, "Not enough bytes in output array");
            return;
        }
        for (int nBytes = bytes - 1; nBytes >= 0; --nBytes) {
            out[index++] = (byte)(in >> 8 * nBytes);
        }
    }

    public static String toUnsignedString(int i) {
        if (i >= 0) {
            return Integer.toString(i);
        }
        long l = i;
        return Long.toString(l &= 0xFFFFFFFFL);
    }
}

