/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.stringhandler;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.digest.SHA1;
import com.crystaldecisions.celib.stringhandler.BinToAscii;
import com.crystaldecisions.celib.stringhandler.CryptoSystem;
import com.crystaldecisions.celib.stringhandler.CryptoUtil;
import com.crystaldecisions.celib.stringhandler.StringHandlerException;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class StrongStringHandler
implements Cloneable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.stringhandler.StrongStringHandler");
    private static final int VERSIONLENGTH = 4;
    private static final int IVLENGTH = 8;
    private static final int SHALENGTH = 20;
    private static final int HEADERSIZE = 32;
    private static final int V0HEADERSIZE = 28;
    private static final Random s_rand = new Random();
    private CryptoSystem m_crypto = null;

    public StrongStringHandler(CryptoSystem system) {
        LOG.assertNotNull((Object)system, "system is null.");
        this.m_crypto = system;
    }

    public byte[] makeKey(String keyin) throws StringHandlerException {
        return this.makeKeyHelper(keyin);
    }

    private byte[] makeKeyHelper(String keyin) throws StringHandlerException {
        try {
            int length = this.m_crypto.getKeySize();
            byte[] out = new byte[length];
            byte[] utf = keyin.getBytes("UTF8");
            SHA1 md = new SHA1();
            int diglength = Math.min(md.getDigestLength(), length);
            md.reset();
            md.update(utf);
            md.digest(out, 0, diglength);
            int nExtra = length - diglength;
            if (nExtra > 0) {
                md.reset();
                md.update(out, 0, diglength);
                md.update(utf);
                md.digest(out, nExtra, diglength);
            }
            return out;
        }
        catch (Exception xn) {
            throw new StringHandlerException.Unexpected(xn.getLocalizedMessage());
        }
    }

    public byte[] makeKey(int keyin) throws StringHandlerException {
        return this.makeKeyHelper(keyin);
    }

    private byte[] makeKeyHelper(int keyin) throws StringHandlerException {
        int length = this.m_crypto.getKeySize();
        int minPhraseLength = length + length / 2 + 1;
        String passPhrase = this.makePassPhrase(keyin, minPhraseLength);
        return this.makeKey(passPhrase);
    }

    public String makePassPhrase(int key, int minimumLength) {
        return this.makePassPhraseHelper(key, minimumLength);
    }

    private String makePassPhraseHelper(int key, int minimumLength) {
        String keyString = CryptoUtil.toUnsignedString(key);
        int length = keyString.length();
        int times = minimumLength / length + 1;
        StringBuffer passPhrase = new StringBuffer(times * length);
        for (int i = 0; i < times; ++i) {
            passPhrase.append(keyString);
        }
        return passPhrase.toString();
    }

    public String pack(String cleartext, byte[] key) throws StringHandlerException {
        return this.encrypt(cleartext, key);
    }

    private String encrypt(String cleartext, byte[] key) throws StringHandlerException {
        if (key.length != this.m_crypto.getKeySize()) {
            throw new StringHandlerException.WrongKeySize(this.m_crypto.getKeySize());
        }
        try {
            int bs = this.m_crypto.getBlockSize();
            long IV = s_rand.nextLong();
            byte[] utf = cleartext.getBytes("UTF8");
            int cleartextlength = utf.length;
            int padding = bs - cleartextlength % bs;
            if (padding == 0) {
                padding = bs;
            }
            int length = cleartextlength + padding;
            byte[] cleartextArray = new byte[length];
            System.arraycopy(utf, 0, cleartextArray, 0, cleartextlength);
            for (int i = cleartextlength; i < length; ++i) {
                cleartextArray[i] = (byte)padding;
            }
            byte[] cyphertextArray = new byte[length + 32];
            CryptoUtil.l2b(1L, cyphertextArray, 0, 4);
            CryptoUtil.l2b(IV, cyphertextArray, 4);
            SHA1 md = new SHA1();
            md.reset();
            md.update(cyphertextArray, 4, 8);
            md.update(cleartextArray, 0, cleartextlength);
            md.digest(cyphertextArray, 12, 20);
            this.m_crypto.encrypt(key, cleartextArray, 0, IV, cyphertextArray, 32);
            return BinToAscii.ToAscii(cyphertextArray);
        }
        catch (Exception e) {
            LOG.error((Object)("encrypt: Unexpected error: " + e.getLocalizedMessage()));
            return "";
        }
    }

    public String pack(String cleartext, String strkey) throws StringHandlerException {
        return this.encrypt(cleartext, strkey);
    }

    private String encrypt(String cleartext, String strkey) throws StringHandlerException {
        byte[] key = this.makeKey(strkey);
        return this.encrypt(cleartext, key);
    }

    public String unpack(String cyphertext, String strkey) throws StringHandlerException {
        return this.decrypt(cyphertext, strkey);
    }

    private String decrypt(String cyphertext, String strkey) throws StringHandlerException {
        byte[] key = this.makeKey(strkey);
        return this.decrypt(cyphertext, key);
    }

    public String unpack(String cyphertext, byte[] key) throws StringHandlerException {
        return this.decrypt(cyphertext, key);
    }

    private String decrypt(String cyphertext, byte[] key) throws StringHandlerException {
        String ret;
        Buffer cleartext;
        if (key.length != this.m_crypto.getKeySize()) {
            throw new StringHandlerException.WrongKeySize(this.m_crypto.getKeySize());
        }
        byte[] cyphertextArray = BinToAscii.ToBin(cyphertext);
        long Version2 = 0L;
        int cleartextlength = 0;
        byte[] cleartextArray = null;
        int cyphertextArrayLen = cyphertextArray.length;
        if ((cyphertextArrayLen - 28) % 8 == 0) {
            Version2 = 0L;
            cleartext = this.decryptV1(cyphertextArray, key, 0, 8, 28);
            cleartextlength = cleartext.length;
            cleartextArray = cleartext.data;
        } else if ((cyphertextArrayLen - 32) % 8 == 0) {
            Version2 = CryptoUtil.b2l(cyphertextArray, 0, 4);
            if (Version2 == 1L) {
                cleartext = this.decryptV1(cyphertextArray, key, 4, 12, 32);
                cleartextlength = cleartext.length;
                cleartextArray = cleartext.data;
            }
        } else {
            LOG.assertTrue(false, "cyphertextArray has invalid length");
            throw new StringHandlerException.UnpackFailed();
        }
        if (cleartextlength == -1) {
            throw new StringHandlerException.UnpackFailed();
        }
        if (cleartextlength == 0) {
            return "";
        }
        if (Version2 == 0L) {
            if (cleartextArray[cleartextlength - 1] == 0 && cleartextArray[cleartextlength - 2] == 0) {
                cleartextlength -= 2;
            }
        } else if (cleartextArray[cleartextlength - 1] == 0) {
            --cleartextlength;
        }
        try {
            ret = Version2 == 0L ? new String(cleartextArray, 0, cleartextlength, "UTF-16LE") : new String(cleartextArray, 0, cleartextlength, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"decrypt: UTF8 not supported", (Throwable)e);
            ret = "";
        }
        return ret;
    }

    public int getKeySize() {
        return this.m_crypto.getKeySize();
    }

    public int getBlockSize() {
        return this.m_crypto.getBlockSize();
    }

    private Buffer decryptV1(byte[] cyphertextArray, byte[] key, int IV_offset, int SHA_offset, int data_offset) throws StringHandlerException {
        Buffer ret = new Buffer(-1, null);
        long IV = CryptoUtil.b2l(cyphertextArray, IV_offset);
        byte[] cleartextArray = new byte[cyphertextArray.length - data_offset];
        this.m_crypto.decrypt(key, cyphertextArray, data_offset, IV, cleartextArray, 0);
        byte padding = cleartextArray[cleartextArray.length - 1];
        if (padding > 8 || padding < 1) {
            return ret;
        }
        int cleartextlength = cleartextArray.length - padding;
        SHA1 md = new SHA1();
        md.reset();
        md.update(cyphertextArray, IV_offset, 8);
        md.update(cleartextArray, 0, cleartextlength);
        byte[] digest = md.digest();
        for (int i = 0; i < 20; ++i) {
            if (digest[i] == cyphertextArray[i + SHA_offset]) continue;
            return ret;
        }
        ret.length = cleartextlength;
        ret.data = cleartextArray;
        return ret;
    }

    private static class Buffer {
        public byte[] data;
        public int length;

        public Buffer(int i, byte[] b) {
            this.data = b;
            this.length = i;
        }
    }
}

