/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.uri;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IStreamBagPacker;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.URLPacker;
import com.crystaldecisions.celib.properties.URLUnpacker;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public abstract class AbstractURI {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.uri.AbstractURI");
    private PropertyBag m_properties;
    protected String m_protocol;
    protected String m_path;
    protected String m_propertiesString;

    public AbstractURI() {
    }

    public AbstractURI(String uri) throws SILibException {
        this.parseURI(uri);
    }

    public AbstractURI(String m_protocol, String m_path, PropertyBag m_properties) {
        this.m_protocol = m_protocol;
        this.m_path = m_path;
        this.m_properties = m_properties;
    }

    public String getPath() {
        return this.m_path;
    }

    public PropertyBag getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new PropertyBag();
            if (this.m_propertiesString != null) {
                IBagUnpacker unpacker = this.getUnpacker();
                unpacker.initialize(this.m_propertiesString);
                this.m_properties.unpack(unpacker);
            }
        }
        return this.m_properties;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void setProperties(PropertyBag properties) {
        this.m_properties = properties;
        this.m_propertiesString = null;
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.protocolToString(sw);
            this.pathToString(sw, this.m_properties != null || this.m_propertiesString != null);
            this.propertiesToString(sw);
        }
        catch (IOException e) {
            LOG.error((Object)"toString(): this should never happen", (Throwable)e);
        }
        return sw.getBuffer().toString();
    }

    protected IStreamBagPacker getPacker() {
        return new URLPacker();
    }

    protected IBagUnpacker getUnpacker() {
        return new URLUnpacker();
    }

    protected int parseProtocol(String in, int start) throws SILibException {
        int colon = in.indexOf(58);
        this.m_protocol = in.substring(start, colon);
        return colon + 1;
    }

    protected abstract int parsePath(String var1, int var2) throws SILibException;

    protected int parseProperties(String in, int start) throws SILibException {
        this.m_propertiesString = in.substring(start);
        this.m_properties = null;
        return in.length();
    }

    protected void protocolToString(Writer out) throws IOException {
        out.write(this.m_protocol);
        out.write(58);
    }

    protected abstract void pathToString(Writer var1, boolean var2) throws IOException;

    protected void propertiesToString(Writer out) throws IOException {
        if (this.m_properties != null && this.m_properties.isDirty()) {
            IStreamBagPacker packer = this.getPacker();
            packer.packToStream(this.m_properties, 0, 0, false, out);
        } else if (this.m_propertiesString != null) {
            out.write(this.m_propertiesString);
        }
    }

    private void parseURI(String in) throws SILibException {
        int pos = this.parseProtocol(in, 0);
        pos = this.parsePath(in, pos);
        this.parseProperties(in, pos);
    }
}

