/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.uri;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.uri.AbstractURI;
import com.crystaldecisions.celib.uri.URIException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class FrsURL
extends AbstractURI {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.uri.FrsURL");
    private static final String FRS_PROTOCOL = "frs";
    private String m_host;
    private String m_filePath;

    public FrsURL(String url) throws SILibException {
        super(url);
    }

    public FrsURL(String hostname, String filePath) {
        this.m_protocol = FRS_PROTOCOL;
        this.m_path = null;
        this.m_host = hostname.endsWith("/") ? hostname.substring(0, hostname.length() - 1) : hostname;
        this.m_filePath = !filePath.startsWith("/") ? "/" + filePath : filePath;
    }

    public boolean isValid() {
        return this.m_host != null && this.m_filePath != null;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public String getPath() {
        StringWriter sw = null;
        try {
            sw = new StringWriter();
            this.pathToString(sw, false);
        }
        catch (IOException e) {
            LOG.error((Object)"getPath(): this shouldn't happen", (Throwable)e);
        }
        return sw.getBuffer().toString();
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public void setFilePath(String filePath) {
        this.m_filePath = filePath;
    }

    public void setPath(String path) {
        try {
            this.parsePath(path, 0);
        }
        catch (SILibException sILibException) {
            // empty catch block
        }
    }

    protected int parseProtocol(String in, int start) throws SILibException {
        int pos = super.parseProtocol(in, start);
        if (!this.m_protocol.equals(FRS_PROTOCOL)) {
            throw new URIException.Invalid(in);
        }
        return pos;
    }

    protected int parsePath(String in, int start) throws SILibException {
        if (in.charAt(start) == '/' && in.charAt(start + 1) == '/') {
            int hostDelim = in.indexOf(47, start + 2);
            if (hostDelim == -1) {
                throw new URIException.Invalid(in);
            }
            this.m_host = in.substring(start + 2, hostDelim);
            this.m_filePath = in.substring(hostDelim);
            this.m_path = null;
            return in.length();
        }
        throw new URIException.Invalid(in);
    }

    protected void pathToString(Writer out, boolean hasProperties) throws IOException {
        out.write("//");
        out.write(this.m_host);
        out.write(this.m_filePath);
    }
}

