/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.framework.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.collections.ISimpleCache;
import com.crystaldecisions.celib.collections.SimpleCache;
import com.crystaldecisions.enterprise.ocaframework.IServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.OCAFrameworkException;
import com.crystaldecisions.enterprise.ocaframework.ServerSpec;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.framework.IEnterpriseSession;
import com.crystaldecisions.sdk.framework.internal.IEnterpriseSessionSecurity;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.internal.IInternalInfoStore;
import com.crystaldecisions.sdk.occa.infostore.internal.InternalInfoStoreFactory;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginMgr;
import com.crystaldecisions.sdk.occa.security.ILogonTokenMgr;
import com.crystaldecisions.sdk.occa.security.ISecurityInfoMgr;
import com.crystaldecisions.sdk.occa.security.IUserInfo;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occamgr.internal.IDisposable;
import com.crystaldecisions.sdk.occamgr.internal.IOCCAFactory;
import com.crystaldecisions.sdk.occamgr.internal.OCCAMgrFactory;
import com.crystaldecisions.sdk.pojomgr.internal.IPOJOMgr;
import com.crystaldecisions.sdk.pojomgr.internal.IPOJOServiceFactory;
import com.crystaldecisions.sdk.pojomgr.internal.POJOMgrFactory;
import com.crystaldecisions.sdk.properties.IProperties;
import com.crystaldecisions.sdk.properties.internal.PropertyIDs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

class EnterpriseSession
implements IEnterpriseSession,
IEnterpriseSessionSecurity,
IDisposable,
Externalizable {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.framework.internal.EnterpriseSession");
    private ISecuritySession m_logon;
    private IServiceMgr m_serviceMgr;
    private IPluginMgr m_pluginMgr;
    private static final ISimpleCache m_serverNamesCache = new SimpleCache(new HashMap(), 120000L);
    private static final ISimpleCache.IRefreshHelper m_serverNamesRefresher = new ISimpleCache.IRefreshHelper(){

        public boolean isCacheOutdated(Object cached, Object[] args) {
            return false;
        }

        public Object refresh(Object key, Object[] args) throws SDKException {
            ISecuritySession session = (ISecuritySession)args[0];
            IInternalInfoStore is = (IInternalInfoStore)InternalInfoStoreFactory.getFactory().makeOCCA("", session);
            IInfoObjects objs = is.query("SELECT SI_NAME FROM CI_SYSTEMOBJS WHERE SI_PARENTID = 16");
            Iterator iter = objs.iterator();
            String[] names = new String[objs.size()];
            int i = 0;
            while (iter.hasNext()) {
                IInfoObject obj = (IInfoObject)iter.next();
                names[i++] = (String)obj.properties().getProperty((Object)PropertyIDs.SI_NAME).getValue();
            }
            return names;
        }
    };
    private static boolean s_sessLogging = false;

    EnterpriseSession(ISecuritySession logon) throws SDKException {
        this.m_logon = logon;
        this.m_serviceMgr = ServiceMgrFactory.getServiceMgr();
        this.m_pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", this.m_logon);
    }

    public EnterpriseSession() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_logon);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.m_logon = (ISecuritySession)in.readObject();
            this.m_serviceMgr = ServiceMgrFactory.getServiceMgr();
            this.m_pluginMgr = (IPluginMgr)OCCAMgrFactory.getOCCAMgr().getOCCAFactory("PluginDistribution").makeOCCA("", this.m_logon);
        }
        catch (SDKException e) {
            throw new SDKException.Serialization(e);
        }
    }

    public String getCMSName() {
        return this.m_logon.getAPSName();
    }

    public String getAPSName() {
        return this.getCMSName();
    }

    public int getAPSVersion() throws SDKException {
        return this.getEnterpriseVersion();
    }

    public String[] getClusterMembers() throws SDKException {
        ServerSpec spec = new ServerSpec("", "", this.m_logon.getAPSName(), this.m_logon.getClusterName());
        return ServiceMgrFactory.getServiceMgr().getClusterMembers(spec);
    }

    public String[] getActiveClusterMembers() throws SDKException {
        ServerSpec spec = new ServerSpec("", "", this.m_logon.getAPSName(), this.m_logon.getClusterName());
        return ServiceMgrFactory.getServiceMgr().getActiveClusterMembers(spec);
    }

    public String getClusterName() {
        return this.m_logon.getClusterName();
    }

    public int getEnterpriseVersion() throws SDKException {
        return this.m_logon.getAPSVersion();
    }

    public ILogonTokenMgr getLogonTokenMgr() throws SDKException {
        return this.m_logon.getLogonTokenMgr();
    }

    public IPluginMgr getPluginManager() throws SDKException {
        return this.m_pluginMgr;
    }

    public ISecuritySession getSecuritySession() {
        return this.m_logon;
    }

    public String[] getServerNames() throws SDKException {
        ServerSpec spec = new ServerSpec("", "", this.m_logon.getAPSName(), this.m_logon.getClusterName());
        try {
            return (String[])m_serverNamesCache.get((Object)spec, new Object[]{this.m_logon}, m_serverNamesRefresher);
        }
        catch (ISimpleCache.RefreshException e) {
            throw (SDKException)((Object)e.getReason());
        }
    }

    public String[] getServiceNames(String svr, int type) throws SDKException {
        try {
            String kind;
            String serverName;
            if ("".equalsIgnoreCase(svr)) {
                serverName = this.m_logon.getAPSName();
                kind = "aps";
            } else {
                serverName = svr;
                int delim = serverName.lastIndexOf(46);
                kind = delim != -1 ? "INVALID" : "aps";
            }
            return this.m_serviceMgr.getServiceNames(new ServerSpec(serverName, kind, this.m_logon.getAPSName(), false), this.m_logon.getUserURI(), type == 1);
        }
        catch (OCAFrameworkException e) {
            throw new SDKException.ServiceFailure("", svr, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getService(String svr, String svc) throws SDKException {
        void var4_6;
        Object service;
        LOG.debug((Object)"getService(): enter");
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getService(): service=" + svc + ", server=" + svr));
        }
        Object factory = OCCAMgrFactory.getOCCAMgr().getOCCAFactory2(svc);
        LOG.assertNotNull(factory, "factory is null.");
        if (factory instanceof IOCCAFactory) {
            IOCCAFactory occaFactory = (IOCCAFactory)factory;
            service = occaFactory.makeOCCA(svr, this.m_logon);
        } else if (factory instanceof IPOJOServiceFactory) {
            IPOJOServiceFactory factory2 = (IPOJOServiceFactory)factory;
            service = POJOMgrFactory.getPOJOMgr().makePOJO(svc, IPOJOMgr.InvocationPolicy.REMOTE_INVOCATION, svr, this.m_logon, factory2);
        } else {
            throw new SDKException.ServiceNotFound(svc, null);
        }
        LOG.assertNotNull((Object)var4_6, "service is null.");
        LOG.debug((Object)"getService(): exit");
        return var4_6;
    }

    public Object getService(String ServiceName) throws SDKException {
        return this.getService("", ServiceName);
    }

    public IProperties getSystemInfoProperties() throws SDKException {
        return this.m_logon.getSystemInfoProperties();
    }

    public IUserInfo getUserInfo() throws SDKException {
        return this.m_logon.getUserInfo();
    }

    public void logoff() {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug((Object)("EnterpriseSession: logoff(): aps=" + this.getCMSName() + ",cluster=" + this.getClusterName() + ",userInfo=" + this.getUserInfo() + ",uri=" + this.m_logon.getUserURI()), (Throwable)new Exception("EnterpriseSession:logoff()"));
            }
            catch (SDKException sDKException) {
                // empty catch block
            }
        }
        this.m_logon.logoff();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"logoff(): exit");
        }
    }

    public String toString() {
        return "(EnterpriseSession:logon=" + this.m_logon + ",service manager=" + this.m_serviceMgr + ",pluginMgr=" + this.m_pluginMgr + ")";
    }

    public String getSerializedSession() throws SDKException {
        if (s_sessLogging) {
            LOG.error((Object)("EnterpriseSession: getSerializedSession(): aps=" + this.getCMSName() + ",cluster=" + this.getClusterName() + ",userInfo=" + this.getUserInfo() + ",uri=" + this.m_logon.getUserURI()));
        }
        String serializedSession = this.m_logon.getSessionID();
        if (s_sessLogging) {
            LOG.error((Object)("EnterpriseSession: getSerializedSession(): serializedSession=" + serializedSession));
        }
        return serializedSession;
    }

    public void dispose(boolean distributable) {
        if (!distributable) {
            this.logoff();
        } else {
            if (LOG.isErrorEnabled()) {
                try {
                    LOG.error((Object)("EnterpriseSession: dispose(): aps=" + this.getCMSName() + ",cluster=" + this.getClusterName() + ",userInfo=" + this.getUserInfo() + ",uri=" + this.m_logon.getUserURI()), (Throwable)new Exception("EnterpriseSession:dispose()"));
                }
                catch (SDKException sDKException) {
                    // empty catch block
                }
            }
            this.m_logon.expire();
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public boolean isDisposed() {
        if (this.m_logon.isSessionLoggedOff()) {
            return true;
        }
        return this.m_logon.isSessionExpired();
    }

    public ISecurityInfoMgr getSecurityInfoMgr() throws SDKException {
        return this.m_logon.getSecurityInfoMgr();
    }

    public boolean isUserDefaultLocale() throws SDKException {
        return this.m_logon.isUserDefaultLocale();
    }

    public void setUserDefaultLocale() throws SDKException {
        this.m_logon.setUserDefaultLocale();
    }

    public Locale getLocale() throws SDKException {
        return this.m_logon.getLocale();
    }

    public void setLocale(Locale value) throws SDKException {
        this.m_logon.setLocale(value);
    }

    public Locale getEffectivePreferredViewingLocale() throws SDKException {
        return this.m_logon.getEffectivePreferredViewingLocale();
    }

    static {
        try {
            String sessLogging = System.getenv("SESSION_LOGGING");
            if (sessLogging != null && sessLogging.trim().equals("1")) {
                s_sessLogging = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

