/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.framework.internal;

import com.businessobjects.foundation.language.LangException;
import com.businessobjects.foundation.language.LangMgr;
import com.businessobjects.foundation.language.LocaleHelper;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.framework.ILanguageMgr;
import java.util.List;
import java.util.Locale;

class LanguageMgr
implements ILanguageMgr {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.framework.internal.LanguageMgr");
    private static ILanguageMgr m_singleton = null;
    private static LangMgr m_langMgr = null;

    private LanguageMgr() {
        m_langMgr = LangMgr.makeLangMgr();
    }

    public static synchronized ILanguageMgr makeLanguageMgr() {
        if (m_singleton == null) {
            m_singleton = new LanguageMgr();
        }
        return m_singleton;
    }

    public synchronized List getSupportedLocales() {
        return m_langMgr.getSupportedLocales();
    }

    public List getInstalledLocales() throws SDKException {
        try {
            return m_langMgr.getInstalledLocales();
        }
        catch (LangException.InstallLocaleFileNotFoundException e) {
            throw new SDKException.FileNotFound(e.getCause().getMessage());
        }
        catch (LangException e) {
            throw new SDKException.Unexpected((Exception)((Object)e));
        }
    }

    public Locale getEffectiveInstalledLocale(Locale locale) throws SDKException {
        Locale loc = LocaleHelper.getEffectiveLocale((List)this.getInstalledLocales(), (Locale)locale);
        if (loc == null) {
            LOG.error((Object)"getEffectiveInstalledLocale(): Could not obtain locale.");
            throw new SDKException.Unexpected();
        }
        return loc;
    }
}

