/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.framework.internal;

import com.businessobjects.foundation.commandline.Parameters;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.celib.collections.SystemPrioritizedProperties;
import com.crystaldecisions.celib.io.PropertiesReader;
import com.crystaldecisions.enterprise.ocaframework.IServiceMgr;
import com.crystaldecisions.enterprise.ocaframework.ServiceMgrFactory;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.exception.SDKRuntimeException;
import com.crystaldecisions.sdk.framework.IEnterprisePrincipal;
import com.crystaldecisions.sdk.framework.IEnterpriseSession;
import com.crystaldecisions.sdk.framework.ILanguageMgr;
import com.crystaldecisions.sdk.framework.ISessionMgr;
import com.crystaldecisions.sdk.framework.ITrustedPrincipal;
import com.crystaldecisions.sdk.framework.internal.CEFactory;
import com.crystaldecisions.sdk.framework.internal.EnterprisePrincipal;
import com.crystaldecisions.sdk.framework.internal.IEnterpriseSessionSecurity;
import com.crystaldecisions.sdk.framework.internal.LanguageMgr;
import com.crystaldecisions.sdk.framework.internal.TrustedPrincipal;
import com.crystaldecisions.sdk.occa.pluginmgr.IPluginFactory;
import com.crystaldecisions.sdk.occa.security.IEnterpriseLogonInformation;
import com.crystaldecisions.sdk.occa.security.internal.ISecurityMgr;
import com.crystaldecisions.sdk.occa.security.internal.ISecuritySession;
import com.crystaldecisions.sdk.occa.security.internal.SecurityFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class SessionMgr
implements ISessionMgr {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.framework.internal.SessionMgr");
    private String m_socksURI = "";
    private ISecurityMgr m_securityMgr = SecurityFactory.getFactory().makeSecurityMgr();
    private Map m_installedAuths;
    private static final String PROGID_BASE = "PluginID";
    private static final String NAME_BASE = "PluginName";
    private static final String AUTH_PLUGINS = "com/crystaldecisions/sdk/plugin/authPlugins.properties";
    private static final String AUTH_PLUGIN_EXTS = "META-INF/authPluginExts.properties";
    private static final String PLUGIN_RES_PATH = "META-INF/CrystalEnterprise.Plugins/";
    private static final int MAXIMUM_TIKCKET_VALID_TIMES = 1440;
    private static final String CONF_FILE_URL = "businessobjects_enterprise.properties";
    private static final String PLATFORM_CONFIG_FILE = "com/crystaldecisions/sdk/framework/internal/platform_config.properties";
    private static boolean s_sessLogging = false;

    SessionMgr() throws SDKException {
        IServiceMgr mgr = ServiceMgrFactory.getServiceMgr();
        this.initializeSystemProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSystemProperties() {
        String serviceMgrPath;
        String reportAddPath;
        String reportAddName;
        InputStream properties = ClassLoaderHelper.getResourceAsStream((String)CONF_FILE_URL);
        SystemPrioritizedProperties props = new SystemPrioritizedProperties();
        if (properties != null) {
            try {
                Map fromFile = PropertiesReader.readProperties((InputStream)properties);
                props.putAll(fromFile);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    properties.close();
                }
                catch (IOException e) {}
            }
        }
        InputStream stream = ClassLoaderHelper.getResourceAsStream((String)PLATFORM_CONFIG_FILE);
        try {
            props.load(stream);
        }
        catch (IOException e) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
        String osName = props.getProperty("os.name");
        String platform = osName.indexOf("Windows") == 0 ? "win32_x86" : (osName.indexOf("SunOS") != -1 ? "solaris_sparc" : (osName.indexOf("AIX") != -1 ? "aix_rs6000" : (osName.indexOf("Linux") != -1 ? "linux_x86" : (osName.indexOf("HP-UX") != -1 ? (props.getProperty("os.arch").startsWith("IA64") ? "hpux_ia64" : "hpux_pa-risc") : props.getProperty("crystal.enterprise.platform", "unknown")))));
        props.setProperty("platform", platform);
        boolean isWindows = platform.equals("win32_x86");
        String defaultEnterpriseLocation = isWindows ? props.getResolvedValue("bobj.default.enterprise.windows.home") : props.getResolvedValue("bobj.default.enterprise.unix.home");
        String enterpriseHome = props.getResolvedValue("bobj.enterprise.home", props.getResolvedValue("crystal.enterprise.home"));
        if ("%BOBJE_HOME%".equals(enterpriseHome)) {
            enterpriseHome = props.getResolvedValue("crystal.enterprise.home");
        }
        if (enterpriseHome == null) {
            enterpriseHome = defaultEnterpriseLocation;
        }
        enterpriseHome = this.standalizedFolderPath(enterpriseHome);
        props.setProperty("bobj.enterprise.home", enterpriseHome);
        String bobjHome = props.getResolvedValue("crystal.home");
        if (bobjHome == null) {
            bobjHome = isWindows ? props.getResolvedValue("bobj.windows.home") : props.getResolvedValue("bobj.unix.home");
        }
        props.setProperty("bobj.home", bobjHome);
        if (isWindows) {
            reportAddName = props.getResolvedValue("bobj.reportadd.windows.name");
            reportAddPath = props.getResolvedValue("bobj.reportadd.windows.path");
            serviceMgrPath = props.getResolvedValue("bobj.servicemgr.windows.path");
        } else {
            reportAddName = props.getResolvedValue("bobj.reportadd.unix.name");
            reportAddPath = props.getResolvedValue("bobj.reportadd.unix.path");
            serviceMgrPath = null;
        }
        Parameters parameters = Parameters.getInstance();
        parameters.setProperty("crystal.enterprise.javasdk.platform", platform);
        parameters.setProperty("crystal.enterprise.javasdk.report.add", reportAddPath);
        parameters.setProperty("crystal.enterprise.javasdk.report.add.name", reportAddName);
        parameters.setProperty("crystal.enterprise.javasdk.servicemgr.path", serviceMgrPath);
        parameters.setProperty("crystal.home.internal", bobjHome);
        parameters.setProperty("crystal.enterprise.home.internal", enterpriseHome);
        parameters.setProperty("bobj.trustedauth.home", props.getResolvedValue("bobj.trustedauth.home"));
        String defaultRootLocation = "";
        int lastSep = enterpriseHome.lastIndexOf(File.separator);
        if (lastSep > 0) {
            defaultRootLocation = enterpriseHome.substring(0, lastSep);
        }
        parameters.setProperty("bobj.root.internal", defaultRootLocation);
        String unixShell = props.getProperty("unix.bshell", "sh").trim();
        parameters.setProperty("crystal.unix.bshell", unixShell);
        parameters.activate();
    }

    private String standalizedFolderPath(String folder) {
        if (folder != null && (folder = folder.trim()).endsWith(File.separator)) {
            folder = folder.substring(0, folder.length() - 1);
        }
        return folder;
    }

    public String[] getInstalledAuthIDs() {
        if (this.m_installedAuths == null) {
            this.m_installedAuths = new LinkedHashMap();
            this.loadSecurityPluginsInfo(AUTH_PLUGINS);
            this.loadSecurityPluginsInfo(AUTH_PLUGIN_EXTS);
        }
        Set keys = this.m_installedAuths.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public IEnterpriseSession logon(String user, String pwd, String aps, String auth) throws SDKException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("logon(): user=" + user + ",aps=" + aps + ",auth=" + auth));
        }
        if (aps == null || aps.trim().length() == 0) {
            throw new SDKException.InvalidCMSSyntax(aps);
        }
        ISecuritySession logon = this.m_securityMgr.userLogon(user, pwd, aps, this.m_socksURI, aps, auth);
        IEnterpriseSession session = CEFactory.getFactory().makeSession(logon);
        LOG.debug((Object)"logon(): exit");
        return session;
    }

    public IEnterpriseSession logon(GSSCredential userCreds, GSSManager manager, String aps, String auth) throws SDKException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("aps=" + aps + ",auth=" + auth));
        }
        if (aps == null || aps.trim().length() == 0) {
            throw new SDKException.InvalidCMSSyntax(aps);
        }
        ISecuritySession logon = this.m_securityMgr.userLogon(userCreds, manager, aps, this.m_socksURI, aps, auth);
        IEnterpriseSession session = CEFactory.getFactory().makeSession(logon);
        LOG.debug((Object)"logon(): exit");
        return session;
    }

    public IEnterpriseSession logonWithToken(String token) throws SDKException {
        ISecuritySession logon = this.m_securityMgr.logonWithToken(token, this.m_socksURI);
        return CEFactory.getFactory().makeSession(logon);
    }

    public IEnterpriseSession logonWithTokenEx(String token, IEnterpriseLogonInformation LogonInfo) throws SDKException {
        ISecuritySession logon = this.m_securityMgr.logonWithToken(token, this.m_socksURI, LogonInfo);
        return CEFactory.getFactory().makeSession(logon);
    }

    public String nameFromProgID(String ProgId) {
        if (this.m_installedAuths == null) {
            this.m_installedAuths = new LinkedHashMap();
            this.loadSecurityPluginsInfo(AUTH_PLUGINS);
            this.loadSecurityPluginsInfo(AUTH_PLUGIN_EXTS);
        }
        return (String)this.m_installedAuths.get(ProgId);
    }

    public void setSOCKSURI(String SocksURI) {
        this.m_socksURI = SocksURI;
    }

    private void loadSecurityPluginsInfo(String resourcePath) {
        InputStream stream = ClassLoaderHelper.getResourceAsStream((String)resourcePath);
        if (stream != null) {
            try {
                Properties infoProperties = new Properties();
                infoProperties.load(stream);
                int id = 0;
                String progIDKey = PROGID_BASE + id;
                String nameKey = NAME_BASE + id;
                String progID = infoProperties.getProperty(progIDKey);
                String authName = infoProperties.getProperty(nameKey);
                while (progID != null && authName != null) {
                    if (this.isPluginFactoryPresent(progID)) {
                        this.m_installedAuths.put(progID, authName);
                    }
                    progIDKey = PROGID_BASE + ++id;
                    nameKey = NAME_BASE + id;
                    progID = infoProperties.getProperty(progIDKey);
                    authName = infoProperties.getProperty(nameKey);
                }
            }
            catch (IOException e) {
                throw new SDKRuntimeException.Unexpected((Exception)e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e1) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPluginFactoryPresent(String pluginID) {
        boolean result = true;
        String pluginRes = PLUGIN_RES_PATH + pluginID + ".properties";
        InputStream stream = ClassLoaderHelper.getResourceAsStream((String)pluginRes);
        if (stream != null) {
            try {
                Properties infoProperties = new Properties();
                infoProperties.load(stream);
                String factory = infoProperties.getProperty("factory");
                Class factoryClass = ClassLoaderHelper.loadClass((String)factory);
                result = factoryClass != null && IPluginFactory.class.isAssignableFrom(factoryClass);
            }
            catch (IOException e) {
                throw new SDKRuntimeException.Unexpected((Exception)e);
            }
            catch (ClassNotFoundException e) {
                result = false;
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e1) {}
            }
        } else {
            result = false;
        }
        return result;
    }

    public IEnterpriseSession getSession(String serializedSessionString) throws SDKException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getSession(): serialized=" + serializedSessionString));
        }
        if (s_sessLogging) {
            LOG.error((Object)("getSession(): serialized=" + serializedSessionString));
        }
        ISecuritySession logon = this.m_securityMgr.getSession(serializedSessionString);
        IEnterpriseSession session = CEFactory.getFactory().makeSession(logon);
        return session;
    }

    public IEnterprisePrincipal authenticate(String userName, String password, String cmsName, String authentication, int validMinutes) throws SDKException {
        if (validMinutes <= 0 || validMinutes > 1440) {
            throw new SDKException.OutOfRange(validMinutes, 1, 1440);
        }
        ISecuritySession session = this.m_securityMgr.userLogon(userName, password, cmsName, this.m_socksURI, cmsName, authentication);
        String token = session.getLogonTokenMgr().createLogonToken("", validMinutes, -1);
        userName = session.getUserInfo().getUserName();
        session.logoff();
        return new EnterprisePrincipal(token, userName, session.getClusterName());
    }

    public ITrustedPrincipal createTrustedPrincipal(String userName, String cmsName) throws SDKException {
        return new TrustedPrincipal(userName, cmsName);
    }

    public ITrustedPrincipal createTrustedPrincipal(String userName, String cmsName, String info) throws SDKException {
        return new TrustedPrincipal(userName, cmsName, info);
    }

    public void release(Principal principal) throws SDKException {
        if (principal instanceof EnterprisePrincipal) {
            EnterprisePrincipal enterprisePrincipal = (EnterprisePrincipal)principal;
            String token = enterprisePrincipal.getToken();
            ISecuritySession session = enterprisePrincipal.getSession();
            if (session == null) {
                IEnterpriseSession es = this.logon(principal);
                IEnterpriseSessionSecurity sec = (IEnterpriseSessionSecurity)((Object)es);
                session = sec.getSecuritySession();
            }
            session.getLogonTokenMgr().releaseToken(token);
            enterprisePrincipal.setSession(null);
            session.logoff();
        }
    }

    public IEnterpriseSession logon(Principal principal) throws SDKException {
        if (principal instanceof EnterprisePrincipal) {
            EnterprisePrincipal enterprisePrincipal = (EnterprisePrincipal)principal;
            ISecuritySession session = enterprisePrincipal.getSession();
            if (session == null) {
                String token = enterprisePrincipal.getToken();
                session = this.m_securityMgr.logonWithToken(token, this.m_socksURI);
                enterprisePrincipal.setSession(session);
            }
            return CEFactory.getFactory().makeSession(session);
        }
        if (principal instanceof TrustedPrincipal) {
            TrustedPrincipal trustedPrincipal = (TrustedPrincipal)principal;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("logon(): trusted user=" + trustedPrincipal.getName() + ",cms=" + trustedPrincipal.getCMSName()));
            }
            if (!(principal instanceof TrustedPrincipal)) {
                throw new SDKException.InvalidArg("principal");
            }
            return this.logon(trustedPrincipal.getName(), trustedPrincipal.getPassword(), trustedPrincipal.getCMSName(), "secEnterprise");
        }
        throw new SDKException.InvalidArg();
    }

    public IEnterpriseLogonInformation createLogonInfo() {
        return this.m_securityMgr.createLogonInfo();
    }

    public IEnterpriseSession logonEx(String UserName, String Password, String CMSName, String Authentication, IEnterpriseLogonInformation LogonInfo) throws SDKException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("logon(): user=" + UserName + ",aps=" + CMSName + ",auth=" + Authentication));
        }
        if (CMSName == null || CMSName.trim().length() == 0) {
            throw new SDKException.InvalidCMSSyntax(CMSName);
        }
        ISecuritySession logon = this.m_securityMgr.userLogon(UserName, Password, CMSName, this.m_socksURI, CMSName, Authentication, LogonInfo);
        IEnterpriseSession session = CEFactory.getFactory().makeSession(logon);
        LOG.debug((Object)"logon(): exit");
        return session;
    }

    public ILanguageMgr getLanguageMgr() {
        return LanguageMgr.makeLanguageMgr();
    }

    static {
        try {
            String sessLogging = System.getenv("SESSION_LOGGING");
            if (sessLogging != null && sessLogging.trim().equals("1")) {
                s_sessLogging = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

