/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.framework.internal;

import com.businessobjects.foundation.commandline.Parameters;
import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.digest.Digest;
import com.crystaldecisions.celib.digest.MD5;
import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.stringhandler.CryptoFactory;
import com.crystaldecisions.celib.stringhandler.StringHandlerException;
import com.crystaldecisions.celib.stringhandler.StrongStringHandler;
import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.framework.ITrustedPrincipal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class TrustedPrincipal
implements ITrustedPrincipal {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.sdk.framework.internal.TrustedPrincipal");
    private static final String SPECIAL_TRUSTED_AUTH_MARKER = "\t";
    private static final String SEPARATOR = "\t";
    private static String m_sharedSecret;
    private String m_userName;
    private String m_cmsName;
    private String m_thisSharedSecret;
    private boolean m_hasThisSharedSecret;
    public static final String CONFIG_FILE = "TrustedPrincipal.conf";
    public static final String SHARED_SECRET_PROP_NAME = "SharedSecret";

    public TrustedPrincipal(String userName, String cmsName) throws SDKException {
        this.m_userName = userName;
        this.m_cmsName = cmsName;
        this.m_hasThisSharedSecret = false;
    }

    public TrustedPrincipal(String userName, String cmsName, String sharedSecret) throws SDKException {
        this.m_userName = userName;
        this.m_cmsName = cmsName;
        this.m_hasThisSharedSecret = true;
        this.m_thisSharedSecret = sharedSecret;
    }

    public boolean equals(Object another) {
        return another instanceof TrustedPrincipal && ((TrustedPrincipal)another).getName().equals(this.m_userName) && ((TrustedPrincipal)another).getCMSName().equals(this.m_cmsName);
    }

    public String toString() {
        return this.m_userName;
    }

    public int hashCode() {
        return this.m_userName.hashCode();
    }

    public String getName() {
        return this.m_userName;
    }

    public String getCMSName() {
        return this.m_cmsName;
    }

    public String getPassword() throws SDKException {
        String sharedSecret;
        if (this.m_hasThisSharedSecret) {
            if (this.m_thisSharedSecret == null || this.m_thisSharedSecret.length() == 0) {
                LOG.error((Object)"Couldn't find shared secret");
                throw new SDKException.TrustedPrincipalConfigError();
            }
            sharedSecret = this.m_thisSharedSecret;
        } else {
            if (m_sharedSecret == null || m_sharedSecret.length() == 0) {
                LOG.error((Object)"Couldn't find shared secret");
                throw new SDKException.TrustedPrincipalConfigError();
            }
            sharedSecret = m_sharedSecret;
        }
        long time = System.currentTimeMillis();
        try {
            StringBuffer password = new StringBuffer();
            password.append("\t");
            String randomString = this.getRandomString(time, 10);
            String token = randomString + new Long(time).toString();
            token = token + this.m_userName;
            byte[] utf8ByteDigest = token.getBytes("UTF8");
            Digest digest = MD5.digest((byte[])utf8ByteDigest, (int)utf8ByteDigest.length);
            StrongStringHandler crypt = new StrongStringHandler(CryptoFactory.getCrypto((String)"3DES"));
            byte[] key = crypt.makeKey(sharedSecret);
            String digestStr = digest.toString() + "\u0000";
            String encrypted = crypt.pack(digestStr, key);
            password.append(encrypted);
            password.append("\t");
            password.append(randomString);
            password.append("\t");
            password.append(new Long(time).toString());
            return password.toString();
        }
        catch (StringHandlerException e) {
            LOG.error((Object)("Encryption error: " + e.getMessage()));
            throw new SDKException.Unexpected();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Unsupported encoding: " + e.getMessage()));
            throw new SDKException.Unexpected();
        }
        catch (SILibException e) {
            LOG.error((Object)("generating digest error: " + e.getMessage()));
            throw new SDKException.Unexpected();
        }
    }

    private String getRandomString(long seed, int length) {
        Random sequence = new Random(seed);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int rand = sequence.nextInt();
            int val = 33 + (rand >= 0 ? rand : rand * -1) % 93;
            buff.append((char)val);
        }
        return buff.toString();
    }

    static {
        Parameters parameters = Parameters.getInstance();
        String configFilePath = null;
        StringBuffer configFilePathBuffer = null;
        File file = null;
        String trustedAuthHomePath = System.getProperty("bobj.trustedauth.home");
        if (trustedAuthHomePath == null) {
            trustedAuthHomePath = parameters.getProperty("bobj.trustedauth.home");
        }
        if (trustedAuthHomePath != null) {
            configFilePathBuffer = new StringBuffer();
            configFilePathBuffer.append(trustedAuthHomePath);
            configFilePathBuffer.append(File.separator);
            configFilePathBuffer.append(CONFIG_FILE);
            configFilePath = configFilePathBuffer.toString();
            file = new File(configFilePath);
        }
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            try {
                int lineFeedIndex;
                FileInputStream fis = null;
                fis = new FileInputStream(file);
                int avail = fis.available();
                byte[] content = new byte[avail];
                fis.read(content);
                String contentStr = new String(content, "UTF-8");
                int carrigeReturnIndex = contentStr.indexOf("\r");
                String line = null;
                line = carrigeReturnIndex != -1 ? contentStr.substring(0, carrigeReturnIndex) : ((lineFeedIndex = contentStr.indexOf("\n")) != -1 ? contentStr.substring(0, lineFeedIndex) : contentStr);
                int equalSignIndex = line.indexOf("=");
                m_sharedSecret = equalSignIndex != -1 ? line.substring(equalSignIndex + 1) : line;
                fis.close();
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Shared secret file is not found. File is:" + configFilePath));
            }
            catch (IOException e) {
                LOG.error((Object)("Shared secret file is not available. File is:" + configFilePath));
            }
        } else {
            LOG.error((Object)("Shared secret file is not found, or is not a file, or couldn't be read. The file is:" + configFilePath));
        }
    }
}

